/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.statistics.util.FieldableDocumentHitCollector;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.search.IndexSearcher;

public class PrefixFieldableHitCollector
extends FieldableDocumentHitCollector {
    private final FieldSelector fieldSelector;
    private final String fieldId;
    private final String prefix;
    private final Set<String> results;

    public PrefixFieldableHitCollector(IndexSearcher searcher, String fieldId, String prefix, Set<String> results) {
        super(searcher);
        this.fieldId = Assertions.notNull("fieldId", fieldId);
        this.prefix = Assertions.notNull("prefix", prefix);
        this.results = Assertions.notNull("results", results);
        this.fieldSelector = new SetBasedFieldSelector(CollectionBuilder.newBuilder(fieldId).asSet(), Collections.emptySet());
    }

    @Override
    protected FieldSelector getFieldSelector() {
        return this.fieldSelector;
    }

    @Override
    public void collect(Document doc) {
        String[] values;
        for (String value : values = doc.getValues(this.fieldId)) {
            if (!value.startsWith(this.prefix)) continue;
            this.results.add(value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PrefixFieldableHitCollector that = (PrefixFieldableHitCollector)((Object)o);
        if (!this.fieldId.equals(that.fieldId)) {
            return false;
        }
        if (!this.prefix.equals(that.prefix)) {
            return false;
        }
        return ((Object)this.results).equals(that.results);
    }

    public int hashCode() {
        int result = this.fieldId.hashCode();
        result = 31 * result + this.prefix.hashCode();
        result = 31 * result + ((Object)this.results).hashCode();
        return result;
    }
}

