/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.util.LongComparator;
import java.util.Comparator;
import org.apache.lucene.document.NumberTools;

public class VotesStatisticsMapper
implements StatisticsMapper {
    public static final StatisticsMapper MAPPER = new VotesStatisticsMapper();

    @Override
    public String getDocumentConstant() {
        return "issue_votes";
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        return NumberTools.stringToLong((String)documentValue);
    }

    @Override
    public Comparator getComparator() {
        return LongComparator.COMPARATOR;
    }

    public boolean isValidValue(Object value) {
        return true;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VotesStatisticsMapper that = (VotesStatisticsMapper)o;
        return "issue_votes".equals(that.getDocumentConstant());
    }

    @Override
    public int hashCode() {
        return "issue_votes".hashCode();
    }
}

