/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.web.bean.PercentageGraphModel;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class StatsGroup
extends AbstractMap {
    private final StatisticsMapper mapper;
    private final Map<Object, Collection<Issue>> headings;
    private Map valuesCache = new HashMap();
    private Collection<Issue> irrelevantIssues = new ArrayList<Issue>();

    public StatsGroup(StatisticsMapper mapper) {
        this.mapper = mapper;
        this.headings = new TreeMap(mapper.getComparator());
    }

    public void addValue(String heading, Issue issue) {
        Object headingValue = this.getHeadingValue(heading);
        if (!this.mapper.isValidValue(headingValue)) {
            return;
        }
        Collection<Issue> currentValues = this.headings.get(headingValue);
        if (currentValues == null) {
            currentValues = new LinkedHashSet<Issue>();
        }
        currentValues.add(issue);
        this.headings.put(headingValue, currentValues);
    }

    public void addIrrelevantIssue(Issue issue) {
        this.irrelevantIssues.add(issue);
    }

    public Collection getIrrelevantIssues() {
        return this.irrelevantIssues;
    }

    private Object getHeadingValue(String heading) {
        Object headingValue = this.valuesCache.get(heading);
        if (headingValue == null) {
            headingValue = this.mapper.getValueFromLuceneField(heading);
            this.valuesCache.put(heading, headingValue);
        }
        return headingValue;
    }

    @Override
    public Set entrySet() {
        return this.headings.entrySet();
    }

    public PercentageGraphModel getResolvedIssues(Object heading) throws Exception {
        long allIssuesSize = this.getAllIssueCount(this.headings.get(heading));
        if (allIssuesSize == 0L) {
            return new PercentageGraphModel();
        }
        long openIssues = this.getOpenIssueCount(this.headings.get(heading));
        PercentageGraphModel model = new PercentageGraphModel();
        model.addRow("#009900", allIssuesSize - openIssues, "Resolved Issues", null);
        model.addRow("#cc0000", openIssues, "Unresolved Issues", null);
        return model;
    }

    public PercentageGraphModel getIrrelevantResolvedIssues() throws Exception {
        long allIssuesSize = this.irrelevantIssues.size();
        if (allIssuesSize == 0L) {
            return new PercentageGraphModel();
        }
        long openIssues = this.getOpenIssueCount(this.irrelevantIssues);
        PercentageGraphModel model = new PercentageGraphModel();
        model.addRow("#009900", allIssuesSize - openIssues, "Resolved Issues", null);
        model.addRow("#cc0000", openIssues, "Unresolved Issues", null);
        return model;
    }

    public long getAllIssueCount(Collection issues) {
        if (issues == null || issues.isEmpty()) {
            return 0L;
        }
        return issues.size();
    }

    public long getResolvedIssueCount(Collection issues) {
        if (issues == null || issues.isEmpty()) {
            return 0L;
        }
        return (long)issues.size() - this.getOpenIssueCount(issues);
    }

    public long getOpenIssueCount(Collection issues) {
        if (issues == null || issues.isEmpty()) {
            return 0L;
        }
        long matchingIssues = 0L;
        for (Object issue1 : issues) {
            Issue issue = (Issue)issue1;
            if (issue.getResolution() != null) continue;
            ++matchingIssues;
        }
        return matchingIssues;
    }

    public StatisticsMapper getMapper() {
        return this.mapper;
    }
}

