/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import java.util.Comparator;

public class SecurityLevelStatisticsMapper
implements StatisticsMapper {
    private final IssueSecurityLevelManager issueSecurityLevelManager;

    public SecurityLevelStatisticsMapper(IssueSecurityLevelManager issueSecurityLevelManager) {
        this.issueSecurityLevelManager = issueSecurityLevelManager;
    }

    @Override
    public String getDocumentConstant() {
        return "issue_security_level";
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        if ("-1".equals(documentValue)) {
            return null;
        }
        return this.issueSecurityLevelManager.getIssueSecurity(new Long(documentValue));
    }

    @Override
    public Comparator getComparator() {
        return OfBizComparators.NAME_COMPARATOR;
    }

    public boolean isValidValue(Object value) {
        return true;
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityLevelStatisticsMapper that = (SecurityLevelStatisticsMapper)o;
        return this.getDocumentConstant() != null ? this.getDocumentConstant().equals(that.getDocumentConstant()) : that.getDocumentConstant() == null;
    }

    @Override
    public int hashCode() {
        return this.getDocumentConstant() != null ? this.getDocumentConstant().hashCode() : 0;
    }
}

