/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.statistics.LocalDateFieldSorter;
import com.atlassian.jira.util.LuceneUtils;
import java.util.Comparator;
import java.util.Date;

public class DateFieldSorter
implements LuceneFieldSorter<Date> {
    public static final LuceneFieldSorter<Date> ISSUE_CREATED_STATSMAPPER = new DateFieldSorter("created");
    public static final LuceneFieldSorter<Date> ISSUE_UPDATED_STATSMAPPER = new DateFieldSorter("updated");
    public static final LuceneFieldSorter<LocalDate> ISSUE_DUEDATE_STATSMAPPER = new LocalDateFieldSorter("duedate");
    public static final LuceneFieldSorter<Date> ISSUE_RESOLUTION_DATE_STATSMAPPER = new DateFieldSorter("resolutiondate");
    private static final Comparator<Date> SIMPLE_COMPARATOR = new SimpleDateComparator();
    private final String documentConstant;

    public DateFieldSorter(String documentConstant) {
        this.documentConstant = documentConstant;
    }

    @Override
    public String getDocumentConstant() {
        return this.documentConstant;
    }

    @Override
    public Date getValueFromLuceneField(String documentValue) {
        if (documentValue == null) {
            return null;
        }
        return LuceneUtils.stringToDate(documentValue);
    }

    @Override
    public Comparator<Date> getComparator() {
        return SIMPLE_COMPARATOR;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateFieldSorter that = (DateFieldSorter)o;
        return this.documentConstant != null ? this.documentConstant.equals(that.documentConstant) : that.documentConstant == null;
    }

    @Override
    public int hashCode() {
        return this.documentConstant != null ? this.documentConstant.hashCode() : 0;
    }

    private static class SimpleDateComparator
    implements Comparator<Date> {
        private SimpleDateComparator() {
        }

        @Override
        public int compare(Date o1, Date o2) {
            return o1.compareTo(o2);
        }
    }
}

