/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.security.IssueSecurityHelper;

public class IssueSecurityHelperImpl
implements IssueSecurityHelper {
    private final FieldLayoutManager fieldLayoutManager;

    public IssueSecurityHelperImpl(FieldLayoutManager fieldLayoutManager) {
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @Override
    public boolean securityLevelNeedsMove(Issue sourceIssue, Issue targetIssue) {
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(sourceIssue);
        FieldLayoutItem fieldLayoutItem = layout.getFieldLayoutItem("security");
        if (fieldLayoutItem == null) {
            return false;
        }
        OrderableField orderableField = fieldLayoutItem.getOrderableField();
        return orderableField.needsMove(EasyList.build((Object)sourceIssue), targetIssue, fieldLayoutItem).getResult();
    }
}

