/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.util;

import com.atlassian.jira.issue.search.util.QueryOptimizer;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public class RedundantClausesQueryOptimizer
implements QueryOptimizer {
    @Override
    public Query optimizeQuery(Query query) {
        Clause whereClause = query.getWhereClause();
        if (whereClause == null) {
            return query;
        }
        return new QueryImpl(whereClause.accept(new ClauseOptimizerVisitor()), query.getOrderByClause(), null);
    }

    private static class ClauseOptimizerVisitor
    implements ClauseVisitor<Clause> {
        private static final Function<Clause, Clause> optimizer = new Function<Clause, Clause>(){

            @Override
            public Clause get(Clause clause) {
                return clause.accept(new ClauseOptimizerVisitor());
            }
        };
        Set<TerminalClause> uniqueClauses = new LinkedHashSet<TerminalClause>();

        private ClauseOptimizerVisitor() {
        }

        @Override
        public Clause visit(AndClause andClause) {
            ArrayList<Clause> subClauses = new ArrayList<Clause>();
            for (Clause clause : andClause.getClauses()) {
                if (clause instanceof TerminalClause) {
                    if (!this.uniqueClauses.add((TerminalClause)clause)) continue;
                    subClauses.add(clause);
                    continue;
                }
                if (clause instanceof AndClause) {
                    Clause cl = clause.accept(this);
                    if (cl == null) continue;
                    subClauses.add(cl);
                    continue;
                }
                subClauses.add(optimizer.get(clause));
            }
            return subClauses.isEmpty() ? null : (subClauses.size() == 1 ? (Clause)subClauses.get(0) : new AndClause(subClauses));
        }

        @Override
        public Clause visit(NotClause notClause) {
            return new NotClause(optimizer.get(notClause.getSubClause()));
        }

        @Override
        public Clause visit(OrClause orClause) {
            return new OrClause(CollectionUtil.transform(orClause.getClauses(), optimizer));
        }

        @Override
        public Clause visit(TerminalClause clause) {
            return clause;
        }

        @Override
        public Clause visit(WasClause clause) {
            return clause;
        }

        @Override
        public Clause visit(ChangedClause clause) {
            return clause;
        }
    }
}

