/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.util;

import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operator.Operator;

public class FreeTextVisitor
implements ClauseVisitor<Boolean> {
    public static boolean containsFreeTextCondition(Clause clause) {
        if (clause == null) {
            return false;
        }
        FreeTextVisitor visitor = new FreeTextVisitor();
        return clause.accept(visitor);
    }

    @Override
    public Boolean visit(AndClause andClause) {
        return this.doVisit(andClause);
    }

    @Override
    public Boolean visit(NotClause notClause) {
        return this.doVisit(notClause);
    }

    @Override
    public Boolean visit(OrClause orClause) {
        return this.doVisit(orClause);
    }

    @Override
    public Boolean visit(TerminalClause clause) {
        Operator operator = clause.getOperator();
        return operator == Operator.LIKE || operator == Operator.NOT_LIKE;
    }

    @Override
    public Boolean visit(WasClause clause) {
        return false;
    }

    @Override
    public Boolean visit(ChangedClause clause) {
        return false;
    }

    private Boolean doVisit(Clause andClause) {
        for (Clause clause : andClause.getClauses()) {
            if (!clause.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }
}

