/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.MultiClause;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RelevantSearcherVisitor
implements ClauseVisitor<Boolean> {
    private static final Logger log = Logger.getLogger(RelevantSearcherVisitor.class);
    private final Map<String, IssueSearcher> searchers = new HashMap<String, IssueSearcher>();
    private final User user;
    private final SearchHandlerManager searchHandlerManager;
    private final SearchContext searchContext;

    public RelevantSearcherVisitor(SearchHandlerManager searchHandlerManager, User user, SearchContext searchContext) {
        this.searchContext = Assertions.notNull("searchContext", searchContext);
        this.searchHandlerManager = Assertions.notNull("searchHandlerManager", searchHandlerManager);
        this.user = user;
    }

    public Set<IssueSearcher> getRelevantSearchers() {
        return new HashSet<IssueSearcher>(this.searchers.values());
    }

    @Override
    public Boolean visit(AndClause andClause) {
        return this.visitMultiClause(andClause);
    }

    @Override
    public Boolean visit(NotClause notClause) {
        return notClause.getSubClause().accept(this);
    }

    @Override
    public Boolean visit(OrClause orClause) {
        return this.visitMultiClause(orClause);
    }

    @Override
    public Boolean visit(TerminalClause clause) {
        IssueSearcher searcher = this.getSearcher(clause);
        if (searcher == null) {
            return false;
        }
        this.searchers.put(searcher.getSearchInformation().getId(), searcher);
        return true;
    }

    @Override
    public Boolean visit(WasClause clause) {
        return false;
    }

    @Override
    public Boolean visit(ChangedClause clause) {
        return false;
    }

    private boolean visitMultiClause(MultiClause multiClause) {
        boolean returnValue;
        Clause clause;
        Iterator<Clause> iterator = multiClause.getClauses().iterator();
        for (returnValue = true; returnValue && iterator.hasNext(); returnValue &= clause.accept(this).booleanValue()) {
            clause = iterator.next();
        }
        return returnValue;
    }

    private IssueSearcher getSearcher(TerminalClause clause) {
        Collection<IssueSearcher<?>> searchersByClauseName = this.searchHandlerManager.getSearchersByClauseName(this.user, clause.getName(), this.searchContext);
        if (searchersByClauseName.size() == 1) {
            return searchersByClauseName.iterator().next();
        }
        log.debug((Object)String.format("Unable to resolve only one searcher for field '%s', found '%d' searchers", clause.getName(), searchersByClauseName.size()));
        return null;
    }
}

