/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.issue.search.searchers.impl.QuerySearcher;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;

class QueryNavigatorCollectorVisitor
extends SimpleNavigatorCollectorVisitor {
    private boolean seenQueryClauses = false;
    private boolean inQueryOr = false;

    public QueryNavigatorCollectorVisitor() {
        super(QuerySearcher.QUERY_JQL_FIELD_NAMES);
    }

    @Override
    public Void visit(OrClause orClause) {
        boolean oldValidPath = this.validPath;
        if (!this.seenQueryClauses && this.isQueryOrClause(orClause)) {
            this.seenQueryClauses = true;
            this.inQueryOr = true;
        } else {
            this.validPath = false;
        }
        for (Clause clause : orClause.getClauses()) {
            clause.accept(this);
        }
        this.inQueryOr = false;
        this.validPath = oldValidPath;
        return null;
    }

    boolean isQueryOrClause(OrClause orClause) {
        for (Clause clause : orClause.getClauses()) {
            if (QuerySearcher.QUERY_JQL_FIELD_NAMES.contains(clause.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Void visit(TerminalClause terminalClause) {
        super.visit(terminalClause);
        if (QuerySearcher.QUERY_JQL_FIELD_NAMES.contains(terminalClause.getName())) {
            if (this.seenQueryClauses && !this.inQueryOr || terminalClause.getOperator() != Operator.LIKE) {
                this.valid = false;
            } else if (!this.seenQueryClauses && !this.inQueryOr) {
                this.seenQueryClauses = true;
            }
        }
        return null;
    }
}

