/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.SingleValueOperand;

public class IssueConstantIndexedInputHelper<T extends IssueConstant>
extends DefaultIndexedInputHelper<T> {
    private final NameResolver<T> issueConstantResolver;

    public IssueConstantIndexedInputHelper(IndexInfoResolver<T> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker, NameResolver<T> issueConstantResolver) {
        super(indexInfoResolver, operandResolver, fieldFlagOperandRegistry, searchContextVisibilityChecker);
        this.issueConstantResolver = Assertions.notNull("issueConstantResolver", issueConstantResolver);
    }

    @Override
    protected SingleValueOperand createSingleValueOperandFromId(String stringValue) {
        long issueConstantId;
        try {
            issueConstantId = Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            return new SingleValueOperand(stringValue);
        }
        IssueConstant issueConstant = (IssueConstant)this.issueConstantResolver.get(issueConstantId);
        if (issueConstant != null) {
            return new SingleValueOperand(issueConstant.getName());
        }
        return new SingleValueOperand(issueConstantId);
    }
}

