/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operand.SingleValueOperand;

public class ComponentIndexedInputHelper
extends DefaultIndexedInputHelper<ProjectComponent> {
    private final NameResolver<ProjectComponent> componentResolver;

    public ComponentIndexedInputHelper(IndexInfoResolver<ProjectComponent> componentIndexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker, NameResolver<ProjectComponent> componentResolver) {
        super(componentIndexInfoResolver, operandResolver, fieldFlagOperandRegistry, searchContextVisibilityChecker);
        this.componentResolver = Assertions.notNull("componentResolver", componentResolver);
    }

    @Override
    protected SingleValueOperand createSingleValueOperandFromId(String stringValue) {
        long projectComponentId;
        try {
            projectComponentId = Long.parseLong(stringValue);
        }
        catch (NumberFormatException e) {
            return new SingleValueOperand(stringValue);
        }
        ProjectComponent projectComponent = this.componentResolver.get(projectComponentId);
        if (projectComponent != null) {
            return new SingleValueOperand(projectComponent.getName());
        }
        return new SingleValueOperand(projectComponentId);
    }
}

