/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.IdIndexedSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.search.searchers.util.IndexedInputHelper;
import com.atlassian.jira.issue.search.searchers.util.VersionIndexedInputHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class VersionSearchInputTransformer
extends IdIndexedSearchInputTransformer<Version> {
    private final NameResolver<Version> versionResolver;
    private final ClauseNames clauseNames;
    private final VersionManager versionManager;

    public VersionSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, IndexInfoResolver<Version> versionIndexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker, NameResolver<Version> versionResolver, VersionManager versionManager) {
        super(clauseNames, urlParameterName, versionIndexInfoResolver, operandResolver, fieldFlagOperandRegistry, searchContextVisibilityChecker);
        this.versionManager = versionManager;
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
        this.clauseNames = Assertions.notNull("clauseNames", clauseNames);
    }

    @Override
    IndexedInputHelper createIndexedInputHelper() {
        return new VersionIndexedInputHelper(this.indexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry, this.searchContextVisibilityChecker, this.versionResolver);
    }

    @Override
    public Clause getSearchClause(User searcher, FieldValuesHolder fieldValuesHolder) {
        Set<String> versionIdsFromHolder = this.getValuesFromHolder(fieldValuesHolder);
        if (versionIdsFromHolder != null && versionIdsFromHolder.size() > 0) {
            IndexedInputHelper inputHelper = this.isVersionsRelatedToProjects(fieldValuesHolder) ? this.getDefaultIndexedInputHelper() : this.getIndexedInputHelper();
            return inputHelper.getClauseForNavigatorValues(this.clauseNames.getPrimaryName(), versionIdsFromHolder);
        }
        return null;
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        boolean structureIsCorrect = super.doRelevantClausesFitFilterForm(searcher, query, searchContext);
        if (!structureIsCorrect) {
            return structureIsCorrect;
        }
        return !this.queryContainsArchivedVersions(searcher, query);
    }

    boolean queryContainsArchivedVersions(User searcher, Query query) {
        SimpleNavigatorCollectorVisitor collector = new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept(collector);
            if (collector.getClauses().size() == 1) {
                TerminalClause terminalClause = collector.getClauses().get(0);
                ArrayList<String> ids = new ArrayList<String>();
                Operand operand = terminalClause.getOperand();
                if (operand instanceof FunctionOperand) {
                    return false;
                }
                List<QueryLiteral> queryLiteralList = this.operandResolver.getValues(searcher, operand, terminalClause);
                for (QueryLiteral queryLiteral : queryLiteralList) {
                    if (queryLiteral.getStringValue() != null) {
                        ids.addAll(this.indexInfoResolver.getIndexedValues(queryLiteral.getStringValue()));
                        continue;
                    }
                    if (queryLiteral.getLongValue() == null) continue;
                    ids.addAll(this.indexInfoResolver.getIndexedValues(queryLiteral.getLongValue()));
                }
                for (String idStr : ids) {
                    Version version;
                    Long lid = this.parseLong(idStr);
                    if (lid == null || (version = this.versionManager.getVersion(lid)) == null || !version.isArchived()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isVersionsRelatedToProjects(FieldValuesHolder fieldValuesHolder) {
        List projects = (List)fieldValuesHolder.get(SystemSearchConstants.forProject().getUrlParameter());
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        if (projects.size() == 1 && projects.contains("-1")) {
            return false;
        }
        return projects.size() <= 1;
    }

    private Long parseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }
}

