/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.search.searchers.util.UserFitsNavigatorHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UserSearchInputTransformer
implements SearchInputTransformer {
    private static final Logger log = Logger.getLogger(UserSearchInputTransformer.class);
    private final UserFieldSearchConstants searchConstants;
    private final UserFitsNavigatorHelper userFitsNavigatorHelper;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private final String emptySelectFlag;

    public UserSearchInputTransformer(UserFieldSearchConstantsWithEmpty searchConstants, UserFitsNavigatorHelper userFitsNavigatorHelper, GroupManager groupManager, UserManager userManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.emptySelectFlag = searchConstants.getEmptySelectFlag();
        this.searchConstants = searchConstants;
        this.userFitsNavigatorHelper = userFitsNavigatorHelper;
    }

    public UserSearchInputTransformer(UserFieldSearchConstants searchConstants, UserFitsNavigatorHelper userFitsNavigatorHelper, GroupManager groupManager, UserManager userManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.emptySelectFlag = null;
        this.searchConstants = searchConstants;
        this.userFitsNavigatorHelper = userFitsNavigatorHelper;
    }

    @Override
    public void populateFromParams(User searcher, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        fieldValuesHolder.put(this.searchConstants.getSelectUrlParameter(), actionParams.getFirstValueForKey(this.searchConstants.getSelectUrlParameter()));
        if (actionParams.containsKey(this.searchConstants.getFieldUrlParameter()) && !actionParams.containsKey(this.searchConstants.getSelectUrlParameter())) {
            fieldValuesHolder.put(this.searchConstants.getSelectUrlParameter(), this.searchConstants.getSpecificUserSelectFlag());
        }
        fieldValuesHolder.put(this.searchConstants.getFieldUrlParameter(), actionParams.getFirstValueForKey(this.searchConstants.getFieldUrlParameter()));
    }

    @Override
    public void validateParams(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        String user = (String)fieldValuesHolder.get(this.searchConstants.getFieldUrlParameter());
        if (StringUtils.isNotBlank((String)user)) {
            String userTypeSelectList = (String)fieldValuesHolder.get(this.searchConstants.getSelectUrlParameter());
            if (this.searchConstants.getSpecificUserSelectFlag().equals(userTypeSelectList)) {
                if (!this.userExists(user)) {
                    errors.addError(this.searchConstants.getFieldUrlParameter(), i18nHelper.getText("admin.errors.could.not.find.username", user));
                }
            } else if (this.searchConstants.getSpecificGroupSelectFlag().equals(userTypeSelectList) && !this.groupExists(user)) {
                errors.addError(this.searchConstants.getFieldUrlParameter(), i18nHelper.getText("admin.errors.abstractusersearcher.could.not.find.group", user));
            }
        }
    }

    @Override
    public void populateFromQuery(User searcher, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        if (query == null) {
            return;
        }
        List<TerminalClause> clauses = this.getMatchingClauses(this.searchConstants.getJqlClauseNames().getJqlFieldNames(), query);
        for (TerminalClause clause : clauses) {
            Operand operand = clause.getOperand();
            if (operand instanceof SingleValueOperand) {
                SingleValueOperand svop = (SingleValueOperand)operand;
                String stringValue = svop.getStringValue() == null ? svop.getLongValue().toString() : svop.getStringValue();
                String user = this.userFitsNavigatorHelper.checkUser(stringValue);
                if (user == null) continue;
                fieldValuesHolder.put(this.searchConstants.getFieldUrlParameter(), user);
                fieldValuesHolder.put(this.searchConstants.getSelectUrlParameter(), this.searchConstants.getSpecificUserSelectFlag());
                continue;
            }
            if (operand instanceof FunctionOperand) {
                FunctionOperand fop = (FunctionOperand)operand;
                if ("membersOf".equalsIgnoreCase(fop.getName()) && fop.getArgs().size() == 1) {
                    String group = fop.getArgs().get(0);
                    fieldValuesHolder.put(this.searchConstants.getFieldUrlParameter(), group);
                    fieldValuesHolder.put(this.searchConstants.getSelectUrlParameter(), this.searchConstants.getSpecificGroupSelectFlag());
                    continue;
                }
                if (!"currentUser".equalsIgnoreCase(fop.getName())) continue;
                fieldValuesHolder.put(this.searchConstants.getSelectUrlParameter(), this.searchConstants.getCurrentUserSelectFlag());
                continue;
            }
            if (operand instanceof EmptyOperand && this.emptySelectFlag != null) {
                fieldValuesHolder.put(this.searchConstants.getSelectUrlParameter(), this.emptySelectFlag);
                continue;
            }
            log.warn((Object)("Operand '" + operand + "' cannot be processed in navigator for query '" + query + "'."));
        }
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            SimpleNavigatorCollectorVisitor visitor = this.createSimpleNavigatorCollectorVisitor();
            Clause whereClause = query.getWhereClause();
            whereClause.accept(visitor);
            List<TerminalClause> clauses = visitor.getClauses();
            if (clauses.size() == 0) {
                return true;
            }
            if (clauses.size() != 1 || !visitor.isValid()) {
                return false;
            }
            TerminalClause clause = clauses.get(0);
            Operator operator = clause.getOperator();
            Operand operand = clause.getOperand();
            if (operand instanceof SingleValueOperand) {
                if (operator == Operator.EQUALS) {
                    SingleValueOperand svop = (SingleValueOperand)operand;
                    String user = svop.getStringValue() == null ? svop.getLongValue().toString() : svop.getStringValue();
                    return this.userFitsNavigatorHelper.checkUser(user) != null;
                }
                return false;
            }
            if (operand instanceof FunctionOperand) {
                FunctionOperand fop = (FunctionOperand)operand;
                if ("membersOf".equalsIgnoreCase(fop.getName()) && fop.getArgs().size() == 1 && operator == Operator.IN) {
                    return true;
                }
                return "currentUser".equalsIgnoreCase(fop.getName()) && operator == Operator.EQUALS && this.isUserLoggedIn(searcher);
            }
            return operand instanceof EmptyOperand && this.emptySelectFlag != null && (operator == Operator.EQUALS || operator == Operator.IS);
        }
        return true;
    }

    @Override
    public Clause getSearchClause(User searcher, FieldValuesHolder fieldValuesHolder) {
        String clauseName = this.searchConstants.getJqlClauseNames().getPrimaryName();
        if (this.emptySelectFlag != null && ParameterUtils.paramContains(fieldValuesHolder, this.searchConstants.getSelectUrlParameter(), this.emptySelectFlag)) {
            return new TerminalClauseImpl(clauseName, Operator.IS, new EmptyOperand());
        }
        if (ParameterUtils.paramContains(fieldValuesHolder, this.searchConstants.getSelectUrlParameter(), this.searchConstants.getCurrentUserSelectFlag())) {
            return new TerminalClauseImpl(clauseName, Operator.EQUALS, new FunctionOperand("currentUser"));
        }
        if (fieldValuesHolder.containsKey(this.searchConstants.getFieldUrlParameter()) && (!fieldValuesHolder.containsKey(this.searchConstants.getSelectUrlParameter()) || ParameterUtils.paramContains(fieldValuesHolder, this.searchConstants.getSelectUrlParameter(), this.searchConstants.getSpecificUserSelectFlag()))) {
            String user = ParameterUtils.getStringParam(fieldValuesHolder, this.searchConstants.getFieldUrlParameter());
            return new TerminalClauseImpl(clauseName, Operator.EQUALS, user);
        }
        if (ParameterUtils.paramContains(fieldValuesHolder, this.searchConstants.getSelectUrlParameter(), this.searchConstants.getSpecificGroupSelectFlag()) && fieldValuesHolder.containsKey(this.searchConstants.getFieldUrlParameter())) {
            String group = ParameterUtils.getStringParam(fieldValuesHolder, this.searchConstants.getSelectUrlParameter(), this.searchConstants.getSpecificUserSelectFlag(), this.searchConstants.getFieldUrlParameter());
            return new TerminalClauseImpl(clauseName, Operator.IN, new FunctionOperand("membersOf", group));
        }
        return null;
    }

    private List<TerminalClause> getMatchingClauses(Set<String> jqlClauseNames, Query query) {
        NamedTerminalClauseCollectingVisitor clauseVisitor = new NamedTerminalClauseCollectingVisitor(jqlClauseNames);
        if (query.getWhereClause() != null) {
            query.getWhereClause().accept(clauseVisitor);
            return clauseVisitor.getNamedClauses();
        }
        return Collections.emptyList();
    }

    boolean isUserLoggedIn(User user) {
        return user != null;
    }

    boolean groupExists(String user) {
        return this.groupManager.groupExists(user);
    }

    boolean userExists(String user) {
        return this.userManager.getUserObject(user) != null;
    }

    SimpleNavigatorCollectorVisitor createSimpleNavigatorCollectorVisitor() {
        return new SimpleNavigatorCollectorVisitor(this.searchConstants.getJqlClauseNames().getJqlFieldNames());
    }
}

