/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.impl.QuerySearcher;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DefaultQuerySearcherInputHelper;
import com.atlassian.jira.issue.search.searchers.util.QuerySearcherInputHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.validator.FreeTextFieldValidator;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;

public class QuerySearchInputTransformer
implements SearchInputTransformer {
    private final ApplicationProperties applicationProperties;
    private final JqlOperandResolver operandResolver;

    public QuerySearchInputTransformer(ApplicationProperties applicationProperties, JqlOperandResolver operandResolver) {
        this.applicationProperties = Assertions.notNull("applicationProperties", applicationProperties);
        this.operandResolver = Assertions.notNull("operandResolver", operandResolver);
    }

    @Override
    public void populateFromParams(User searcher, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        fieldValuesHolder.put("query", actionParams.getFirstValueForKey("query"));
        ArrayList<String> queryFields = new ArrayList<String>(4);
        for (String fieldId : QuerySearcher.QUERY_URL_FIELD_PARAMS) {
            String value = actionParams.getFirstValueForKey(fieldId);
            if (!"true".equals(value)) continue;
            fieldValuesHolder.put(fieldId, value);
            queryFields.add(fieldId);
        }
        fieldValuesHolder.put("queryFields", queryFields);
    }

    @Override
    public void populateFromQuery(User searcher, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        QuerySearcherInputHelper helper;
        Map<String, String> result;
        if (query != null && query.getWhereClause() != null && (result = (helper = this.createQuerySearcherInputHelper()).convertClause(query.getWhereClause(), searcher)) != null) {
            fieldValuesHolder.putAll(result);
            ArrayList<String> queryFields = new ArrayList<String>();
            for (String fieldId : result.keySet()) {
                if ("query".equals(fieldId)) continue;
                queryFields.add(fieldId);
            }
            fieldValuesHolder.put("queryFields", queryFields);
        }
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        if (query.getWhereClause() != null) {
            Clause whereClause = query.getWhereClause();
            QuerySearcherInputHelper inputHelper = this.createQuerySearcherInputHelper();
            if (inputHelper.convertClause(whereClause, searcher) == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Clause getSearchClause(User searcher, FieldValuesHolder fieldValuesHolder) {
        String query = ParameterUtils.getStringParam(fieldValuesHolder, "query");
        if (StringUtils.isNotBlank((String)query)) {
            ArrayList<TerminalClauseImpl> clauses = new ArrayList<TerminalClauseImpl>();
            if (fieldValuesHolder.containsKey(SystemSearchConstants.forSummary().getUrlParameter())) {
                clauses.add(new TerminalClauseImpl(SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName(), Operator.LIKE, query));
            }
            if (fieldValuesHolder.containsKey(SystemSearchConstants.forDescription().getUrlParameter())) {
                clauses.add(new TerminalClauseImpl(SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName(), Operator.LIKE, query));
            }
            if (fieldValuesHolder.containsKey(SystemSearchConstants.forComments().getUrlParameter())) {
                clauses.add(new TerminalClauseImpl(SystemSearchConstants.forComments().getJqlClauseNames().getPrimaryName(), Operator.LIKE, query));
            }
            if (fieldValuesHolder.containsKey(SystemSearchConstants.forEnvironment().getUrlParameter())) {
                clauses.add(new TerminalClauseImpl(SystemSearchConstants.forEnvironment().getJqlClauseNames().getPrimaryName(), Operator.LIKE, query));
            }
            if (clauses.size() == 1) {
                return (Clause)clauses.get(0);
            }
            if (!clauses.isEmpty()) {
                return new OrClause(clauses);
            }
        }
        return null;
    }

    @Override
    public void validateParams(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        String query = (String)fieldValuesHolder.get("query");
        if (StringUtils.isNotBlank((String)query)) {
            String firstLetter = String.valueOf(query.charAt(0));
            if (FreeTextFieldValidator.INVALID_FIRST_CHAR_LIST.contains(firstLetter)) {
                errors.addError("query", i18nHelper.getText("navigator.error.query.invalid.start", firstLetter));
            } else if (!this.isQueryValid(query)) {
                errors.addError("query", i18nHelper.getText("navigator.error.parse"));
            }
        }
    }

    private boolean isQueryValid(String query) {
        QueryParser qp = this.createQueryParser();
        try {
            qp.parse(query);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    QuerySearcherInputHelper createQuerySearcherInputHelper() {
        return new DefaultQuerySearcherInputHelper("query", this.operandResolver);
    }

    QueryParser createQueryParser() {
        return new QueryParser(DefaultIndexManager.LUCENE_VERSION, SystemSearchConstants.forSummary().getIndexField(), DefaultIndexManager.ANALYZER_FOR_SEARCHING);
    }
}

