/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class IssueTypeSearchContextVisibilityChecker
implements SearchContextVisibilityChecker {
    private final ProjectManager projectManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;

    public IssueTypeSearchContextVisibilityChecker(ProjectManager projectManager, IssueTypeSchemeManager issueTypeSchemeManager) {
        this.projectManager = projectManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
    }

    @Override
    public Set<String> FilterOutNonVisibleInContext(SearchContext searchContext, Collection<String> ids) {
        if (searchContext.isForAnyProjects()) {
            return new HashSet<String>(ids);
        }
        HashSet<String> types = new HashSet<String>();
        for (Long pid : searchContext.getProjectIds()) {
            Project project = this.projectManager.getProjectObj(pid);
            if (project == null) continue;
            Collection<IssueType> issueTypes = this.issueTypeSchemeManager.getIssueTypesForProject(project);
            for (IssueType issueType : issueTypes) {
                if (!ids.contains(issueType.getId())) continue;
                types.add(issueType.getId());
            }
        }
        return types;
    }
}

