/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.NavigatorStructureChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DefaultIndexedInputHelper;
import com.atlassian.jira.issue.search.searchers.util.IndexedInputHelper;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@NonInjectableComponent
public abstract class IdIndexedSearchInputTransformer<T>
implements SearchInputTransformer {
    private final ClauseNames clauseNames;
    private final String urlParameterName;
    protected final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    protected final JqlOperandResolver operandResolver;
    protected final IndexInfoResolver<T> indexInfoResolver;
    protected final SearchContextVisibilityChecker searchContextVisibilityChecker;
    private final NavigatorStructureChecker navigatorStructureChecker;
    private volatile IndexedInputHelper indexedInputHelper;
    private volatile DefaultIndexedInputHelper defaultIndexedInputHelper;

    public IdIndexedSearchInputTransformer(ClauseNames id, IndexInfoResolver<T> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker) {
        this(id, id.getPrimaryName(), indexInfoResolver, operandResolver, fieldFlagOperandRegistry, searchContextVisibilityChecker);
    }

    public IdIndexedSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, IndexInfoResolver<T> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker) {
        this.clauseNames = clauseNames;
        this.urlParameterName = urlParameterName;
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.operandResolver = operandResolver;
        this.indexInfoResolver = indexInfoResolver;
        this.searchContextVisibilityChecker = searchContextVisibilityChecker;
        this.navigatorStructureChecker = this.createNavigatorStructureChecker();
    }

    IdIndexedSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, IndexInfoResolver<T> indexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, NavigatorStructureChecker navigatorStructureChecker, SearchContextVisibilityChecker searchContextVisibilityChecker) {
        this.clauseNames = clauseNames;
        this.urlParameterName = urlParameterName;
        this.fieldFlagOperandRegistry = fieldFlagOperandRegistry;
        this.operandResolver = operandResolver;
        this.indexInfoResolver = indexInfoResolver;
        this.searchContextVisibilityChecker = searchContextVisibilityChecker;
        this.navigatorStructureChecker = navigatorStructureChecker;
    }

    @Override
    public void populateFromParams(User searcher, FieldValuesHolder fieldValuesHolder, ActionParams actionParams) {
        fieldValuesHolder.put(this.urlParameterName, actionParams.getValuesForKey(this.urlParameterName));
    }

    @Override
    public void validateParams(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
    }

    @Override
    public void populateFromQuery(User searcher, FieldValuesHolder fieldValuesHolder, Query query, SearchContext searchContext) {
        Set<String> valuesAsStrings = this.getIndexedInputHelper().getAllNavigatorValuesForMatchingClauses(searcher, this.clauseNames, query, searchContext);
        fieldValuesHolder.put(this.urlParameterName, valuesAsStrings);
    }

    @Override
    public boolean doRelevantClausesFitFilterForm(User searcher, Query query, SearchContext searchContext) {
        return this.navigatorStructureChecker.checkSearchRequest(query, searchContext);
    }

    @Override
    public Clause getSearchClause(User searcher, FieldValuesHolder fieldValuesHolder) {
        Set<String> constants = this.getValuesFromHolder(fieldValuesHolder);
        if (constants != null && constants.size() > 0) {
            return this.getClauseForValues(constants);
        }
        return null;
    }

    NavigatorStructureChecker<T> createNavigatorStructureChecker() {
        return new NavigatorStructureChecker<T>(this.clauseNames, true, this.fieldFlagOperandRegistry, this.operandResolver, this.indexInfoResolver, this.searchContextVisibilityChecker);
    }

    abstract IndexedInputHelper createIndexedInputHelper();

    Clause getClauseForValues(Set<String> values) {
        return this.getIndexedInputHelper().getClauseForNavigatorValues(this.clauseNames.getPrimaryName(), values);
    }

    Set<String> getValuesFromHolder(FieldValuesHolder fieldValuesHolder) {
        List list = (List)fieldValuesHolder.get(this.urlParameterName);
        if (list == null) {
            return null;
        }
        for (Object o : list) {
            if (o instanceof String) continue;
            throw new IllegalArgumentException("Why are we putting non-String values in the FieldValuesHolder for searcher '" + this.urlParameterName + "'???");
        }
        LinkedHashSet<String> strings = new LinkedHashSet<String>(list);
        return strings;
    }

    protected DefaultIndexedInputHelper getDefaultIndexedInputHelper() {
        if (this.defaultIndexedInputHelper == null) {
            this.defaultIndexedInputHelper = new DefaultIndexedInputHelper<T>(this.indexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry, this.searchContextVisibilityChecker);
        }
        return this.defaultIndexedInputHelper;
    }

    protected IndexedInputHelper getIndexedInputHelper() {
        if (this.indexedInputHelper == null) {
            this.indexedInputHelper = this.createIndexedInputHelper();
        }
        return this.indexedInputHelper;
    }
}

