/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.transformer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.IdIndexedSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.util.ComponentIndexedInputHelper;
import com.atlassian.jira.issue.search.searchers.util.IndexedInputHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import java.util.List;
import java.util.Set;

public class ComponentSearchInputTransformer
extends IdIndexedSearchInputTransformer<ProjectComponent> {
    private final NameResolver<ProjectComponent> componentResolver;
    private final ClauseNames clauseNames;

    public ComponentSearchInputTransformer(ClauseNames clauseNames, String urlParameterName, IndexInfoResolver<ProjectComponent> componentIndexInfoResolver, JqlOperandResolver operandResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry, SearchContextVisibilityChecker searchContextVisibilityChecker, NameResolver<ProjectComponent> componentResolver) {
        super(clauseNames, urlParameterName, componentIndexInfoResolver, operandResolver, fieldFlagOperandRegistry, searchContextVisibilityChecker);
        this.clauseNames = Assertions.notNull("clauseNames", clauseNames);
        this.componentResolver = Assertions.notNull("componentResolver", componentResolver);
    }

    @Override
    public Clause getSearchClause(User searcher, FieldValuesHolder fieldValuesHolder) {
        Set<String> componentIdsFromHolder = this.getValuesFromHolder(fieldValuesHolder);
        if (componentIdsFromHolder != null && componentIdsFromHolder.size() > 0) {
            IndexedInputHelper inputHelper = this.isComponentsNotRelatedToProjects(componentIdsFromHolder, fieldValuesHolder) ? this.getDefaultIndexedInputHelper() : this.getIndexedInputHelper();
            return inputHelper.getClauseForNavigatorValues(this.clauseNames.getPrimaryName(), componentIdsFromHolder);
        }
        return null;
    }

    @Override
    IndexedInputHelper createIndexedInputHelper() {
        return new ComponentIndexedInputHelper(this.indexInfoResolver, this.operandResolver, this.fieldFlagOperandRegistry, this.searchContextVisibilityChecker, this.componentResolver);
    }

    private boolean isComponentsNotRelatedToProjects(Set<String> componentsIdsFromHolder, FieldValuesHolder fieldValuesHolder) {
        List projects = (List)fieldValuesHolder.get(SystemSearchConstants.forProject().getUrlParameter());
        if (projects == null || projects.isEmpty()) {
            return false;
        }
        if (projects.size() == 1 && projects.contains("-1")) {
            return false;
        }
        if (projects.size() > 1) {
            return true;
        }
        for (String componentIdString : componentsIdsFromHolder) {
            ProjectComponent component = this.getComponentFromNavigatorValue(componentIdString);
            if (component == null || projects.contains(component.getProjectId().toString())) continue;
            return true;
        }
        return false;
    }

    private ProjectComponent getComponentFromNavigatorValue(String componentIdString) {
        try {
            Long compId = new Long(componentIdString);
            return this.componentResolver.get(compId);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

