/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.WorkRatioSearcherConfig;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import com.atlassian.velocity.VelocityManager;
import java.util.Map;
import webwork.action.Action;

@NonInjectableComponent
public class WorkRatioSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final SimpleFieldSearchConstants constants;
    private final WorkRatioSearcherConfig config;

    public WorkRatioSearchRenderer(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityManager velocityManager, SimpleFieldSearchConstants searchConstants, String searcherNameKey, FieldVisibilityManager fieldVisibilityManager, WorkRatioSearcherConfig config) {
        super(velocityRequestContextFactory, applicationProperties, velocityManager, searchConstants, searcherNameKey);
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.constants = searchConstants;
        this.config = config;
    }

    @Override
    public boolean isShown(User searcher, SearchContext searchContext) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.constants.getFieldId(), searchContext, searcher);
    }

    @Override
    public String getEditHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        return this.renderEditTemplate("workratio-searcher-edit.vm", velocityParams);
    }

    @Override
    public String getViewHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        return this.renderViewTemplate("workratio-searcher-view.vm", velocityParams);
    }

    @Override
    public boolean isRelevantForQuery(User searcher, Query query) {
        return this.isRelevantForQuery(this.constants.getJqlClauseNames(), query);
    }

    @Override
    protected Map<String, Object> getVelocityParams(User searcher, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = super.getVelocityParams(searcher, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
        velocityParams.put("minField", this.config.getMinField());
        velocityParams.put("maxField", this.config.getMaxField());
        return velocityParams;
    }
}

