/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.comparator.ConstantsComparator;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.renderer.IssueConstantsSearchRenderer;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.velocity.VelocityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class StatusSearchRenderer
extends IssueConstantsSearchRenderer<Status> {
    static final Logger log = Logger.getLogger(IssueSearcher.class);
    private final ConstantsManager constantsManager;
    private final WorkflowManager workflowManager;
    private final ProjectManager projectManager;

    public StatusSearchRenderer(String searcherNameKey, ConstantsManager constantsManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityManager velocityManager, FieldVisibilityManager fieldVisibilityManager, WorkflowManager workflowManager, ProjectManager projectManager) {
        super(SystemSearchConstants.forStatus(), searcherNameKey, constantsManager, velocityRequestContextFactory, applicationProperties, velocityManager, fieldVisibilityManager);
        this.constantsManager = constantsManager;
        this.workflowManager = workflowManager;
        this.projectManager = projectManager;
    }

    @Override
    public Collection<Status> getSelectListOptions(SearchContext searchContext) {
        List<Long> projectIds = searchContext.getProjectIds();
        if (projectIds == null || projectIds.isEmpty()) {
            try {
                HashSet<Status> uniqueStatus = new HashSet<Status>();
                Collection<JiraWorkflow> workflows = this.workflowManager.getActiveWorkflows();
                for (JiraWorkflow jiraWorkflow : workflows) {
                    List<Status> statuses = jiraWorkflow.getLinkedStatusObjects();
                    uniqueStatus.addAll(statuses);
                }
                ArrayList<Status> sortedList = new ArrayList<Status>(uniqueStatus);
                Collections.sort(sortedList, ConstantsComparator.COMPARATOR);
                return sortedList;
            }
            catch (WorkflowException e) {
                log.warn((Object)"Workflow exception occurred trying to get a workflow statuses. Returning all statuses", (Throwable)e);
                return this.constantsManager.getStatusObjects();
            }
        }
        HashSet<Status> uniqueStatus = new HashSet<Status>();
        List<String> issueTypeIds = searchContext.getIssueTypeIds();
        if (issueTypeIds == null || issueTypeIds.isEmpty()) {
            issueTypeIds = this.constantsManager.getAllIssueTypeIds();
        }
        for (Long projectId : projectIds) {
            if (this.projectManager.getProjectObj(projectId) != null) {
                for (String issueTypeId : issueTypeIds) {
                    try {
                        JiraWorkflow workflow = this.workflowManager.getWorkflow(projectId, issueTypeId);
                        List<Status> linkedStatuses = workflow.getLinkedStatusObjects();
                        uniqueStatus.addAll(linkedStatuses);
                    }
                    catch (WorkflowException e) {
                        log.warn((Object)("Workflow exception occurred trying to get a workflow with issuetype " + issueTypeId + " and projectId " + projectId), (Throwable)e);
                    }
                }
                continue;
            }
            log.debug((Object)("Unable to find project with id " + projectId + " when trying to retrieve available statuses"));
        }
        ArrayList<Status> sortedList = new ArrayList<Status>(uniqueStatus);
        Collections.sort(sortedList, ConstantsComparator.COMPARATOR);
        return sortedList;
    }
}

