/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.util.DefaultQuerySearcherInputHelper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import com.atlassian.velocity.VelocityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;

public class QuerySearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final JqlOperandResolver operandResolver;
    private final FieldVisibilityManager fieldVisibilityManager;
    private static final Set<String> QUERY_FIELDS_DEFAULT = CollectionBuilder.newBuilder(SystemSearchConstants.forSummary().getJqlClauseNames().getPrimaryName(), SystemSearchConstants.forDescription().getJqlClauseNames().getPrimaryName()).asSet();

    public QuerySearchRenderer(VelocityRequestContextFactory velocityRequestContextFactory, String nameKey, ApplicationProperties applicationProperties, VelocityManager velocityManager, JqlOperandResolver operandResolver, FieldVisibilityManager fieldVisibilityManager) {
        super(velocityRequestContextFactory, applicationProperties, velocityManager, "query", nameKey);
        this.operandResolver = operandResolver;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public String getEditHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("searchRenderer", this);
        return this.renderEditTemplate("query-edit.vm", velocityParams);
    }

    @Override
    public boolean isShown(User searcher, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("queryFieldNames", this.getQueryFieldNames(searcher, fieldValuesHolder));
        return this.renderViewTemplate("query-view.vm", velocityParams);
    }

    @Override
    public boolean isRelevantForQuery(User searcher, Query query) {
        if (query != null && query.getWhereClause() != null) {
            DefaultQuerySearcherInputHelper querySearcherInputHelper = new DefaultQuerySearcherInputHelper("query", this.operandResolver);
            return querySearcherInputHelper.convertClause(query.getWhereClause(), searcher) != null;
        }
        return false;
    }

    public Collection getQueryFieldNames(User searcher, FieldValuesHolder fieldValuesHolder) {
        List queryFields = (List)fieldValuesHolder.get("queryFields");
        if (queryFields != null && !queryFields.isEmpty()) {
            final Map ID_TO_NAME_MAP = EasyMap.build((Object)SystemSearchConstants.forSummary().getUrlParameter(), (Object)this.getI18n(searcher).getText("issue.field.summary"), (Object)SystemSearchConstants.forDescription().getUrlParameter(), (Object)this.getI18n(searcher).getText("issue.field.description"), (Object)SystemSearchConstants.forEnvironment().getUrlParameter(), (Object)this.getI18n(searcher).getText("issue.field.environment"), (Object)SystemSearchConstants.forComments().getUrlParameter(), (Object)this.getI18n(searcher).getText("common.words.comments"));
            ArrayList queryFieldNames = new ArrayList(queryFields);
            CollectionUtils.transform(queryFieldNames, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return ID_TO_NAME_MAP.get(input);
                }
            });
            return queryFieldNames;
        }
        return null;
    }

    public boolean isFieldSelected(String fieldId, FieldValuesHolder fieldValuesHolder) {
        List queryFields = (List)fieldValuesHolder.get("queryFields");
        if (queryFields != null && queryFields.contains(fieldId)) {
            return true;
        }
        return StringUtils.isBlank((String)((String)fieldValuesHolder.get("query"))) && QUERY_FIELDS_DEFAULT.contains(fieldId);
    }

    public boolean isFieldVisible(User searcher, String fieldId, SearchContext searchContext) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(fieldId, searchContext, searcher);
    }
}

