/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSet;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.atlassian.util.profiling.UtilTimerStack;
import com.atlassian.velocity.VelocityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;

public class IssueTypeSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final ConstantsManager constantsManager;
    private final PermissionManager permissionManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final OptionSetManager optionSetManager;
    private final SubTaskManager subTaskManager;

    public IssueTypeSearchRenderer(String searcherNameKey, ConstantsManager constantsManager, PermissionManager permissionManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityManager velocityManager, IssueTypeSchemeManager issueTypeSchemeManager, OptionSetManager optionSetManager, SubTaskManager subTaskManager) {
        super(velocityRequestContextFactory, applicationProperties, velocityManager, SystemSearchConstants.forIssueType(), searcherNameKey);
        this.constantsManager = constantsManager;
        this.permissionManager = permissionManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.optionSetManager = optionSetManager;
        this.subTaskManager = subTaskManager;
    }

    public String getEditHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        List issueTypes = (List)fieldValuesHolder.get("type");
        velocityParams.put("selectedIssueTypes", issueTypes != null ? issueTypes : Collections.EMPTY_LIST);
        ListOrderedMap projectToConfig = new ListOrderedMap();
        HashSet<FieldConfig> releventConfigs = new HashSet<FieldConfig>();
        Collection allProjects = this.getVisibleProjects(searcher);
        for (GenericValue project : allProjects) {
            FieldConfigScheme configScheme = this.issueTypeSchemeManager.getConfigScheme(project);
            FieldConfig relevantConfig = configScheme.getOneAndOnlyConfig();
            releventConfigs.add(relevantConfig);
            projectToConfig.put(project.getLong("id"), relevantConfig.getId());
        }
        HashMap<Option, String> optionsToCss = new HashMap<Option, String>();
        Collection<Option> visibleIssueTypes = this.getVisibleIssueTypes(searcher, releventConfigs);
        for (Option visibleIssueType : visibleIssueTypes) {
            if (visibleIssueType.getImagePath() == null) continue;
            optionsToCss.put(visibleIssueType, this.getCssClassForOption(visibleIssueType));
        }
        velocityParams.put("visibleIssueTypeStyles", optionsToCss);
        velocityParams.put("projectToConfig", projectToConfig);
        velocityParams.put("visibleIssueTypes", visibleIssueTypes);
        return this.renderEditTemplate("issuetype-searcher-edit.vm", velocityParams);
    }

    @Override
    public boolean isShown(User searcher, SearchContext searchContext) {
        return true;
    }

    public String getViewHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        ArrayList unconvertedIssueTypeIds = new ArrayList((Collection)fieldValuesHolder.get("type"));
        ArrayList<String> types = new ArrayList<String>();
        if (unconvertedIssueTypeIds != null) {
            if (unconvertedIssueTypeIds.contains("-2")) {
                types.add(this.getI18n(searcher).getText("common.filters.standardissuetypes"));
                unconvertedIssueTypeIds.remove("-2");
            }
            if (unconvertedIssueTypeIds.contains("-3")) {
                types.add(this.getI18n(searcher).getText("common.filters.subtaskissuetypes"));
                unconvertedIssueTypeIds.remove("-3");
            }
            if (!unconvertedIssueTypeIds.isEmpty()) {
                List issueTypes = this.constantsManager.convertToConstantObjects("IssueType", unconvertedIssueTypeIds);
                for (IssueConstant issueType : issueTypes) {
                    types.add(issueType.getNameTranslation());
                }
            }
            velocityParams.put("selectedIssueTypes", types);
        }
        return this.renderViewTemplate("issuetype-searcher-view.vm", velocityParams);
    }

    @Override
    public boolean isRelevantForQuery(User searcher, Query query) {
        return this.isRelevantForQuery(SystemSearchConstants.forIssueType().getJqlClauseNames(), query);
    }

    private Collection getVisibleProjects(User searcher) {
        return this.permissionManager.getProjects(10, searcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCssClassForOption(Option option) {
        UtilTimerStack.push((String)"IssueTypeSearchRenderer.getCssClassForOption");
        try {
            Collection allRelatedSchemes = this.issueTypeSchemeManager.getAllRelatedSchemes(option.getId());
            StringBuffer cssClass = new StringBuffer();
            for (FieldConfigScheme configScheme : allRelatedSchemes) {
                FieldConfig config = configScheme.getOneAndOnlyConfig();
                cssClass.append(config.getId()).append(" ");
            }
            String string = cssClass.toString();
            return string;
        }
        finally {
            UtilTimerStack.pop((String)"IssueTypeSearchRenderer.getCssClassForOption");
        }
    }

    private Collection<Option> getVisibleIssueTypes(User searcher, Set releventConfigs) {
        HashSet<Option> allOptions = new HashSet<Option>();
        for (FieldConfig config : releventConfigs) {
            OptionSet optionsForConfig = this.optionSetManager.getOptionsForConfig(config);
            allOptions.addAll(optionsForConfig.getOptions());
        }
        ArrayList optionsList = new ArrayList(allOptions);
        Collections.sort(optionsList);
        if (this.subTaskManager.isSubTasksEnabled()) {
            LinkedList<Option> issueTypes = new LinkedList<Option>();
            I18nHelper i18nHelper = this.getI18n(searcher);
            issueTypes.add(new TextOption("-2", i18nHelper.getText("common.filters.standardissuetypes"), "sectionHeaderOption"));
            issueTypes.addAll(CollectionUtils.select(optionsList, (Predicate)IssueConstantOption.STANDARD_OPTIONS_PREDICATE));
            Collection subTaskOptions = CollectionUtils.select(optionsList, (Predicate)IssueConstantOption.SUB_TASK_OPTIONS_PREDICATE);
            if (subTaskOptions != null && !subTaskOptions.isEmpty()) {
                issueTypes.add(new TextOption("-3", i18nHelper.getText("common.filters.subtaskissuetypes"), "sectionHeaderOption"));
                issueTypes.addAll(subTaskOptions);
            }
            return issueTypes;
        }
        return CollectionUtils.select(optionsList, (Predicate)IssueConstantOption.STANDARD_OPTIONS_PREDICATE);
    }
}

