/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import com.atlassian.velocity.VelocityManager;
import java.util.Collection;
import java.util.Map;
import webwork.action.Action;

public abstract class IssueConstantsSearchRenderer<T extends IssueConstant>
extends AbstractSearchRenderer
implements SearchRenderer {
    private final SimpleFieldSearchConstants constants;
    private final ConstantsManager constantsManager;
    private final FieldVisibilityManager fieldVisibilityManager;

    public IssueConstantsSearchRenderer(SimpleFieldSearchConstants constants, String searcherNameKey, ConstantsManager constantsManager, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityManager velocityManager, FieldVisibilityManager fieldVisibilityManager) {
        super(velocityRequestContextFactory, applicationProperties, velocityManager, constants, searcherNameKey);
        this.constants = constants;
        this.constantsManager = constantsManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public abstract Collection<T> getSelectListOptions(SearchContext var1);

    public String getEditHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("selectedValues", fieldValuesHolder.get(this.constants.getUrlParameter()));
        velocityParams.put("selectListOptions", this.getSelectListOptions(searchContext));
        return this.renderEditTemplate("constants-searcher-edit.vm", velocityParams);
    }

    @Override
    public boolean isShown(User searcher, SearchContext searchContext) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.constants.getFieldId(), searchContext, searcher);
    }

    public String getViewHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        Collection selectedValues = (Collection)fieldValuesHolder.get(this.constants.getUrlParameter());
        velocityParams.put("selectedObjects", this.constantsManager.convertToConstantObjects(this.constants.getUrlParameter(), selectedValues));
        return this.renderViewTemplate("constants-searcher-view.vm", velocityParams);
    }

    @Override
    public boolean isRelevantForQuery(User searcher, Query query) {
        return this.isRelevantForQuery(this.constants.getJqlClauseNames(), query);
    }
}

