/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.option.ComponentOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractProjectConstantsRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.resolver.ComponentResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.velocity.VelocityManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import webwork.action.Action;

public class ComponentSearchRenderer
extends AbstractProjectConstantsRenderer
implements SearchRenderer {
    private static final Logger log = Logger.getLogger(ComponentSearchRenderer.class);
    private final SimpleFieldSearchConstantsWithEmpty searchConstants;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ProjectComponentManager componentManager;
    private final ProjectManager projectManager;
    private final ComponentResolver componentResolver;

    public ComponentSearchRenderer(SimpleFieldSearchConstantsWithEmpty searchConstants, VelocityRequestContextFactory velocityRequestContextFactory, FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties, VelocityManager velocityManager, String searcherNameKey, ProjectComponentManager componentManager, ProjectManager projectManager, ComponentResolver componentResolver) {
        super(velocityRequestContextFactory, applicationProperties, velocityManager, fieldVisibilityManager, searchConstants, searcherNameKey);
        this.searchConstants = searchConstants;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.componentManager = componentManager;
        this.projectManager = projectManager;
        this.componentResolver = componentResolver;
    }

    public String getEditHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, (FieldLayoutItem)null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("selectedValues", fieldValuesHolder.get(this.searchConstants.getSearcherId()));
        velocityParams.put("selectListOptions", this.getSelectListOptions(searcher, searchContext));
        return this.renderEditTemplate("project-constants-searcher-edit.vm", velocityParams);
    }

    public String getViewHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, (FieldLayoutItem)null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("selectedObjects", this.getSelectedObjects(fieldValuesHolder, new ComponentLabelFunction(searcher)));
        velocityParams.put("baseurl", this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl());
        return this.renderViewTemplate("project-constants-searcher-view.vm", velocityParams);
    }

    protected Map<String, Object> getVelocityParams(User searcher, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = super.getVelocityParams(searcher, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
        velocityParams.put("extraOption", EasyMap.build((Object)"value", (Object)this.getI18n(searcher).getText("common.filters.nocomponent"), (Object)"key", (Object)"-1"));
        return velocityParams;
    }

    @Override
    protected List<Option> getSelectListOptions(User searcher, SearchContext searchContext) {
        if (searchContext.isSingleProjectContext()) {
            Long projectId = searchContext.getProjectIds().iterator().next();
            if (this.projectManager.getProjectObj(projectId) != null) {
                return CollectionUtil.transform(this.componentManager.findAllForProject(projectId), ComponentOption.FUNCTION);
            }
            log.warn((Object)("Project for search context " + searchContext + " is invalid"));
        }
        return Collections.emptyList();
    }

    protected class ComponentLabelFunction
    implements Function<String, AbstractProjectConstantsRenderer.GenericProjectConstantsLabel> {
        private final User searcher;

        public ComponentLabelFunction(User searcher) {
            this.searcher = searcher;
        }

        @Override
        public AbstractProjectConstantsRenderer.GenericProjectConstantsLabel get(String input) {
            if (input.equals(ComponentSearchRenderer.this.searchConstants.getEmptySelectFlag())) {
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(ComponentSearchRenderer.this.getI18n(this.searcher).getText("navigator.hidden.search.request.summary.no.components"));
            }
            Long id = new Long(input);
            ProjectComponent component = ComponentSearchRenderer.this.componentResolver.get(id);
            if (component != null) {
                Project project = ComponentSearchRenderer.this.projectManager.getProjectObj(component.getProjectId());
                return new AbstractProjectConstantsRenderer.GenericProjectConstantsLabel(component.getName(), "/browse/" + project.getKey() + "/component/" + component.getId());
            }
            log.warn((Object)("Unknown " + ComponentSearchRenderer.this.searchConstants.getSearcherId() + " selected. Value: " + id));
            return null;
        }
    }
}

