/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.StatusIndexer;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.StatusSearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.IssueConstantSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.StatusSearchContextVisibilityChecker;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IssueConstantInfoResolver;
import com.atlassian.jira.jql.resolver.StatusResolver;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.velocity.VelocityManager;
import java.util.Collections;

@InjectableComponent
public class StatusSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    private final SearchInputTransformer searchInputTransformer;
    private final StatusSearchRenderer searchRenderer;
    private final SearcherInformation<SearchableField> searchInformation;

    public StatusSearcher(FieldVisibilityManager fieldVisibilityManager, ConstantsManager constantsManager, JqlOperandResolver operandResolver, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityManager velocityManager, WorkflowManager workflowManager, ProjectManager projectManager, StatusResolver statusResolver, FieldFlagOperandRegistry fieldFlagOperandRegistry) {
        IssueConstantInfoResolver<Status> constantInfoResolver = new IssueConstantInfoResolver<Status>(statusResolver);
        SimpleFieldSearchConstants constants = SystemSearchConstants.forStatus();
        this.searchInformation = new GenericSearcherInformation<SearchableField>(constants.getSearcherId(), "navigator.filter.status", Collections.singletonList(StatusIndexer.class), this.fieldReference, SearcherGroupType.ISSUE);
        this.searchRenderer = new StatusSearchRenderer(this.searchInformation.getNameKey(), constantsManager, velocityRequestContextFactory, applicationProperties, velocityManager, fieldVisibilityManager, workflowManager, projectManager);
        StatusSearchContextVisibilityChecker searchContextVisibilityChecker = new StatusSearchContextVisibilityChecker(this.searchRenderer);
        this.searchInputTransformer = new IssueConstantSearchInputTransformer<Status>(constants.getJqlClauseNames(), constantInfoResolver, operandResolver, fieldFlagOperandRegistry, searchContextVisibilityChecker, statusResolver);
    }

    @Override
    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searchInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

