/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.index.indexers.impl.IssueTypeIndexer;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.IssueTypeSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.IssueTypeSearchContextVisibilityChecker;
import com.atlassian.jira.issue.search.searchers.transformer.IssueTypeSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.resolver.IssueConstantInfoResolver;
import com.atlassian.jira.jql.resolver.IssueTypeResolver;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.velocity.VelocityManager;
import java.util.Collections;

public class IssueTypeSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;
    private final SearcherInformation<SearchableField> searchInformation;

    public IssueTypeSearcher(ConstantsManager constantsManager, JqlOperandResolver operandResolver, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityManager velocityManager, IssueTypeResolver issueTypeResolver, PermissionManager permissionsManager, IssueTypeSchemeManager issueTypeSchemeManager, OptionSetManager optionSetManager, SubTaskManager subTaskManager, FieldFlagOperandRegistry fieldFlagOperandRegistry, ProjectManager projectManager) {
        IssueConstantInfoResolver<IssueType> indexInfoResolver = new IssueConstantInfoResolver<IssueType>(issueTypeResolver);
        IssueTypeSearchContextVisibilityChecker searchContextVisibilityChecker = new IssueTypeSearchContextVisibilityChecker(projectManager, issueTypeSchemeManager);
        SimpleFieldSearchConstants constants = SystemSearchConstants.forIssueType();
        this.searchInformation = new GenericSearcherInformation<SearchableField>(constants.getSearcherId(), "navigator.filter.issuetype", Collections.singletonList(IssueTypeIndexer.class), this.fieldReference, SearcherGroupType.CONTEXT);
        this.searchInputTransformer = new IssueTypeSearchInputTransformer(indexInfoResolver, operandResolver, fieldFlagOperandRegistry, searchContextVisibilityChecker, issueTypeResolver);
        this.searchRenderer = new IssueTypeSearchRenderer(this.searchInformation.getNameKey(), constantsManager, permissionsManager, velocityRequestContextFactory, applicationProperties, velocityManager, issueTypeSchemeManager, optionSetManager, subTaskManager);
    }

    @Override
    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searchInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

