/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstants;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.impl.AbstractInitializationSearcher;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.DateSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.RelativeDateSearcherInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.util.DateSearcherConfig;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.util.JqlLocalDateSupport;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.velocity.VelocityManager;
import java.util.Collections;

public class AbstractRelativeDateSearcher
extends AbstractInitializationSearcher
implements IssueSearcher<SearchableField> {
    private final SearcherInformation<SearchableField> searcherInformation;
    private final SearchInputTransformer searchInputTransformer;
    private final SearchRenderer searchRenderer;

    public AbstractRelativeDateSearcher(SimpleFieldSearchConstants constants, String nameKey, Class<? extends BaseFieldIndexer> indexer, JqlOperandResolver operandResolver, ApplicationProperties applicationProperties, VelocityRequestContextFactory velocityRenderContext, VelocityManager velocityManager, CalendarLanguageUtil calendarUtils, FieldVisibilityManager fieldVisibilityManager, CustomFieldInputHelper customFieldInputHelper, JqlLocalDateSupport jqlLocalDateSupport, DateTimeFormatterFactory dateTimeFormatterFactory) {
        DateSearcherConfig config = new DateSearcherConfig(constants.getUrlParameter(), constants.getJqlClauseNames(), constants.getJqlClauseNames().getPrimaryName());
        this.searcherInformation = new GenericSearcherInformation<SearchableField>(constants.getSearcherId(), nameKey, Collections.singletonList(indexer), this.fieldReference, SearcherGroupType.DATE);
        this.searchInputTransformer = new RelativeDateSearcherInputTransformer(config, operandResolver, jqlLocalDateSupport, customFieldInputHelper, dateTimeFormatterFactory);
        this.searchRenderer = new DateSearchRenderer(constants, config, nameKey, velocityRenderContext, applicationProperties, velocityManager, calendarUtils, fieldVisibilityManager);
    }

    @Override
    public SearcherInformation<SearchableField> getSearchInformation() {
        return this.searcherInformation;
    }

    @Override
    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    @Override
    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }
}

