/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.issue.search.quicksearch.SingleWordQuickSearchHandler;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.Map;

public class ProjectQuickSearchHandler
extends SingleWordQuickSearchHandler {
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;

    public ProjectQuickSearchHandler(ProjectManager projectManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    protected Map handleWord(String word, QuickSearchResult searchResult) {
        if (word == null) {
            return null;
        }
        Project projectByKey = this.projectManager.getProjectObjByKey(word.toUpperCase());
        if (projectByKey != null && this.hasPermissionToViewProject(projectByKey)) {
            return EasyMap.build((Object)"pid", (Object)projectByKey.getGenericValue().getString("id"));
        }
        Project projectByName = this.projectManager.getProjectObjByName(word);
        if (projectByName != null && this.hasPermissionToViewProject(projectByName)) {
            return EasyMap.build((Object)"pid", (Object)projectByName.getGenericValue().getString("id"));
        }
        return null;
    }

    private boolean hasPermissionToViewProject(Project project) {
        return this.permissionManager.hasPermission(10, project, this.authenticationContext.getLoggedInUser());
    }
}

