/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.filter;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.dbc.Assertions;
import org.ofbiz.core.entity.GenericValue;

public class NoBrowsePermissionPredicate
implements Predicate<GenericValue> {
    private final User searcher;
    private final PermissionManager permissionManager;

    public NoBrowsePermissionPredicate(User searcher) {
        this(searcher, ComponentAccessor.getPermissionManager());
    }

    NoBrowsePermissionPredicate(User searcher, PermissionManager permissionManager) {
        this.searcher = searcher;
        this.permissionManager = Assertions.notNull("permissionManager", permissionManager);
    }

    @Override
    public boolean evaluate(GenericValue issue) {
        return !this.permissionManager.hasPermission(10, issue, this.searcher);
    }
}

