/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.handlers;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.SearchableField;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.handlers.SearchHandlerFactory;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.DefaultClauseHandler;
import com.atlassian.jira.jql.DefaultValuesGeneratingClauseHandler;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.permission.ClauseSanitiser;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.jql.permission.FieldClausePermissionChecker;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.dbc.Assertions;

public abstract class SimpleSearchHandlerFactory
implements SearchHandlerFactory {
    private final Class<? extends IssueSearcher<SearchableField>> searcherClass;
    private final ComponentFactory factory;
    private final ClauseInformation clauseInformation;
    private final ClauseQueryFactory queryFactory;
    private final ClauseContextFactory clauseContextFactory;
    private final ClauseValidator queryValidator;
    private final FieldClausePermissionChecker.Factory clausePermissionFactory;
    private final ClauseSanitiser sanitiser;
    private final ClauseValuesGenerator clauseValuesGenerator;

    public SimpleSearchHandlerFactory(ComponentFactory factory, ClauseInformation information, Class<? extends IssueSearcher<SearchableField>> searcherClass, ClauseQueryFactory queryFactory, ClauseValidator queryValidator, FieldClausePermissionChecker.Factory clausePermissionFactory, ClauseContextFactory clauseContextFactory, ClauseValuesGenerator clauseValuesGenerator) {
        this(factory, information, searcherClass, queryFactory, queryValidator, clausePermissionFactory, clauseContextFactory, clauseValuesGenerator, null);
    }

    public SimpleSearchHandlerFactory(ComponentFactory factory, ClauseInformation information, Class<? extends IssueSearcher<SearchableField>> searcherClass, ClauseQueryFactory queryFactory, ClauseValidator queryValidator, FieldClausePermissionChecker.Factory clausePermissionFactory, ClauseContextFactory clauseContextFactory, ClauseValuesGenerator clauseValuesGenerator, ClauseSanitiser sanitiser) {
        this.clauseContextFactory = Assertions.notNull("clauseContextFactory", clauseContextFactory);
        this.clausePermissionFactory = Assertions.notNull("clausePermissionFactory", clausePermissionFactory);
        this.queryFactory = Assertions.notNull("queryFactory", queryFactory);
        this.queryValidator = Assertions.notNull("queryValidator", queryValidator);
        this.clauseInformation = Assertions.notNull("information", information);
        this.factory = Assertions.notNull("factory", factory);
        this.searcherClass = Assertions.notNull("searcherClass", searcherClass);
        this.clauseValuesGenerator = clauseValuesGenerator;
        this.sanitiser = sanitiser;
    }

    @Override
    public final SearchHandler createHandler(SearchableField field) {
        Assertions.notNull("field", field);
        IssueSearcher<SearchableField> searcher = this.createSearchableField(this.searcherClass, field);
        ClauseHandler clauseHandler = this.clauseValuesGenerator == null ? new DefaultClauseHandler(this.clauseInformation, this.queryFactory, this.queryValidator, this.createClausePermissionHandler(field), this.clauseContextFactory) : new DefaultValuesGeneratingClauseHandler(this.clauseInformation, this.queryFactory, this.queryValidator, this.createClausePermissionHandler(field), this.clauseContextFactory, this.clauseValuesGenerator);
        SearchHandler.ClauseRegistration registration = new SearchHandler.ClauseRegistration(clauseHandler);
        SearchHandler.SearcherRegistration searcherRegistration = new SearchHandler.SearcherRegistration(searcher, registration);
        return new SearchHandler(searcher.getSearchInformation().getRelatedIndexers(), searcherRegistration);
    }

    private IssueSearcher<SearchableField> createSearchableField(Class<? extends IssueSearcher<SearchableField>> clazz, SearchableField field) {
        IssueSearcher<SearchableField> searcher = this.factory.createObject(clazz);
        searcher.init(field);
        return searcher;
    }

    private ClausePermissionHandler createClausePermissionHandler(Field field) {
        if (this.sanitiser == null) {
            return new DefaultClausePermissionHandler(this.clausePermissionFactory.createPermissionChecker(field));
        }
        return new DefaultClausePermissionHandler(this.clausePermissionFactory.createPermissionChecker(field), this.sanitiser);
    }
}

