/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.LazyIssueContext;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class SearchContextImpl
implements SearchContext {
    private static final Logger log = Logger.getLogger(SearchContextImpl.class);
    private static final Predicate LONG_PREDICATE = new AndPredicate(InstanceofPredicate.getInstance(Long.class), ObjectUtils.getIsSetPredicate());
    private static final Predicate STRING_PREDICATE = new AndPredicate(InstanceofPredicate.getInstance(String.class), ObjectUtils.getIsSetPredicate());
    protected List projectCategoryIds;
    protected List<Long> projectIds;
    protected List<String> issueTypeIds;
    private final ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
    private final ProjectManager projectManager = ComponentAccessor.getProjectManager();
    private final PermissionManager permissionManager = ComponentAccessor.getPermissionManager();
    private final JiraAuthenticationContext authenticationContext = ComponentAccessor.getJiraAuthenticationContext();

    public SearchContextImpl() {
    }

    public SearchContextImpl(List projectCategoryIds, List projectIds, List issueTypeIds) {
        this();
        this.setProjectCategoryIds(projectCategoryIds);
        this.setProjectIds(projectIds);
        this.setIssueTypeIds(issueTypeIds);
    }

    public SearchContextImpl(SearchContext searchContext) {
        this(searchContext.getProjectCategoryIds(), searchContext.getProjectIds(), searchContext.getIssueTypeIds());
    }

    @Override
    public boolean isForAnyProjects() {
        return !(this.projectCategoryIds != null && !this.projectCategoryIds.isEmpty() || this.projectIds != null && !this.projectIds.isEmpty());
    }

    @Override
    public boolean isForAnyIssueTypes() {
        return this.issueTypeIds == null || this.issueTypeIds.isEmpty();
    }

    @Override
    public boolean isSingleProjectContext() {
        return this.getProjectIds() != null && this.getProjectIds().size() == 1;
    }

    @Override
    public List getProjectCategoryIds() {
        return this.projectCategoryIds;
    }

    private void setProjectCategoryIds(List projectCategoryIds) {
        this.projectCategoryIds = SearchContextImpl.prepareProjectList(projectCategoryIds);
    }

    @Override
    public List<Long> getProjectIds() {
        return this.projectIds;
    }

    private void setProjectIds(List projectIds) {
        this.projectIds = SearchContextImpl.prepareProjectList(projectIds);
    }

    @Override
    public GenericValue getOnlyProject() {
        if (this.isSingleProjectContext()) {
            Long projectId = this.getProjectIds().get(0);
            return this.projectManager.getProject(projectId);
        }
        log.warn((Object)("Trying to get the only the project but is not a single project context. Project ids are: " + this.getProjectIds()));
        return null;
    }

    @Override
    public List<String> getIssueTypeIds() {
        return this.issueTypeIds;
    }

    @Override
    public List<IssueContext> getAsIssueContexts() {
        ArrayList<IssueContext> issueContexts = new ArrayList<IssueContext>();
        List<Long> projectIds = this.getProjectIds() != null && !this.getProjectIds().isEmpty() ? this.getProjectIds() : EasyList.buildNull();
        for (Long projectId : projectIds) {
            List<String> issueTypeIds = this.getIssueTypeIds() != null && !this.getIssueTypeIds().isEmpty() ? this.getIssueTypeIds() : EasyList.buildNull();
            for (String issueType : issueTypeIds) {
                issueContexts.add(new LazyIssueContext(projectId, issueType));
            }
        }
        return issueContexts;
    }

    @Override
    public void verify() {
        Iterator<Object> iterator;
        if (this.projectIds != null && !this.projectIds.isEmpty()) {
            iterator = this.projectIds.iterator();
            while (iterator.hasNext()) {
                Long projectId = (Long)iterator.next();
                if (this.projectManager.getProject(projectId) != null) continue;
                log.warn((Object)("Project id " + projectId + " found in searchContext but is not valid. Being removed."));
                iterator.remove();
            }
        }
        if (this.issueTypeIds != null && !this.issueTypeIds.isEmpty()) {
            iterator = this.issueTypeIds.iterator();
            while (iterator.hasNext()) {
                String issueTypeId = (String)iterator.next();
                if (this.constantsManager.getIssueType(issueTypeId) != null) continue;
                log.warn((Object)("Issue type id " + issueTypeId + " found in searchContext but is not valid. Being removed."));
                iterator.remove();
            }
        }
    }

    private void setIssueTypeIds(List issueTypeIds) {
        this.issueTypeIds = ListUtils.predicatedList(this.constantsManager.expandIssueTypeIds(issueTypeIds), (Predicate)STRING_PREDICATE);
    }

    private static List<Long> prepareProjectList(List list) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (list.size() == 1 && !ObjectUtils.isValueSelected(list.get(0))) {
            return Collections.emptyList();
        }
        return ListUtils.predicatedList((List)list, (Predicate)LONG_PREDICATE);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(this.getProjectIds()).append(this.getIssueTypeIds()).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SearchContextImpl)) {
            return false;
        }
        SearchContextImpl rhs = (SearchContextImpl)o;
        return new EqualsBuilder().append(this.getProjectIds(), rhs.getProjectIds()).append(this.getIssueTypeIds(), rhs.getIssueTypeIds()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(37, 47).append(this.getProjectIds()).append(this.getIssueTypeIds()).toHashCode();
    }
}

