/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FavouriteFilterLinkFactory
implements SimpleLinkFactory {
    private static final Logger log = Logger.getLogger(FavouriteFilterLinkFactory.class);
    private static final int DEFAULT_FILTER_DROPDOWN_ITEMS = 10;
    private static final int MAX_LABEL_LENGTH = 30;
    private final SearchRequestService searchRequestService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nFactory;

    public FavouriteFilterLinkFactory(SearchRequestService searchRequestService, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nFactory) {
        this.searchRequestService = searchRequestService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.i18nFactory = i18nFactory;
    }

    @Override
    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    @Override
    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        Collection<SearchRequest> filters = this.searchRequestService.getFavouriteFilters(user);
        ArrayList<SimpleLink> links = new ArrayList<SimpleLink>();
        if (filters != null && !filters.isEmpty()) {
            VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
            I18nHelper i18n = this.i18nFactory.getInstance(user);
            String baseUrl = requestContext.getBaseUrl();
            int maxItems = this.getMaxDropdownItems();
            Iterator<SearchRequest> filterIterator = filters.iterator();
            for (int i = 0; i < maxItems && filterIterator.hasNext(); ++i) {
                SearchRequest filter = filterIterator.next();
                String name = filter.getName();
                String shortName = name;
                if (shortName.length() > 30) {
                    shortName = shortName.substring(0, 30) + "...";
                }
                String title = StringUtils.isBlank((String)filter.getDescription()) ? name : i18n.getText("menu.issues.filter.title", name, filter.getDescription());
                links.add(new SimpleLinkImpl("filter_lnk_" + filter.getId(), shortName, title, null, null, null, baseUrl + "/secure/IssueNavigator.jspa?mode=hide&requestId=" + filter.getId(), null));
            }
            if (filters.size() > maxItems) {
                String url = baseUrl + "/secure/ManageFilters.jspa?filterView=favourites";
                links.add(new SimpleLinkImpl("filter_lnk_more", i18n.getText("menu.issues.filter.more"), i18n.getText("menu.issues.filter.more.desc"), null, null, null, url, null));
            }
        }
        return links;
    }

    private int getMaxDropdownItems() {
        int maxItems = 10;
        try {
            maxItems = Integer.parseInt(this.applicationProperties.getDefaultBackedString("jira.max.issue.filter.dropdown.items"));
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Incorrect format of property 'jira.max.issue.filter.dropdown.items'.  Should be a number.");
        }
        return maxItems;
    }
}

