/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.CurrentEstimateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueIdIndexer;
import com.atlassian.jira.issue.index.indexers.impl.IssueKeyIndexer;
import com.atlassian.jira.issue.index.indexers.impl.OriginalEstimateIndexer;
import com.atlassian.jira.issue.index.indexers.impl.ParentIssueIndexer;
import com.atlassian.jira.issue.index.indexers.impl.SecurityIndexer;
import com.atlassian.jira.issue.index.indexers.impl.TimeSpentIndexer;
import com.atlassian.jira.issue.index.indexers.impl.VoterIndexer;
import com.atlassian.jira.issue.index.indexers.impl.VotesIndexer;
import com.atlassian.jira.issue.index.indexers.impl.WatcherIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchHandler;
import com.atlassian.jira.issue.search.SystemClauseHandlerFactory;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.jql.DefaultClauseHandler;
import com.atlassian.jira.jql.DefaultValuesGeneratingClauseHandler;
import com.atlassian.jira.jql.NoOpClauseHandler;
import com.atlassian.jira.jql.context.AllTextClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.IssueIdClauseContextFactory;
import com.atlassian.jira.jql.context.IssueSecurityLevelClauseContextFactory;
import com.atlassian.jira.jql.context.MultiClauseDecoratorContextFactory;
import com.atlassian.jira.jql.context.ProjectCategoryClauseContextFactory;
import com.atlassian.jira.jql.context.SavedFilterClauseContextFactory;
import com.atlassian.jira.jql.context.SimpleClauseContextFactory;
import com.atlassian.jira.jql.context.ValidatingDecoratorContextFactory;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.permission.ClauseSanitiser;
import com.atlassian.jira.jql.permission.DefaultClausePermissionHandler;
import com.atlassian.jira.jql.permission.FieldClausePermissionChecker;
import com.atlassian.jira.jql.permission.IssueClauseValueSanitiser;
import com.atlassian.jira.jql.permission.IssueParentPermissionChecker;
import com.atlassian.jira.jql.permission.NoOpClausePermissionChecker;
import com.atlassian.jira.jql.permission.TimeTrackingPermissionChecker;
import com.atlassian.jira.jql.permission.VotePermissionChecker;
import com.atlassian.jira.jql.permission.WatchPermissionChecker;
import com.atlassian.jira.jql.query.AllTextClauseQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.CurrentEstimateClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueIdClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueParentClauseQueryFactory;
import com.atlassian.jira.jql.query.IssueSecurityLevelClauseQueryFactory;
import com.atlassian.jira.jql.query.OriginalEstimateClauseQueryFactory;
import com.atlassian.jira.jql.query.ProjectCategoryClauseQueryFactory;
import com.atlassian.jira.jql.query.SavedFilterClauseQueryFactory;
import com.atlassian.jira.jql.query.TimeSpentClauseQueryFactory;
import com.atlassian.jira.jql.query.VoterClauseQueryFactory;
import com.atlassian.jira.jql.query.VotesClauseQueryFactory;
import com.atlassian.jira.jql.query.WatcherClauseQueryFactory;
import com.atlassian.jira.jql.query.WatchesClauseQueryFactory;
import com.atlassian.jira.jql.validator.AllTextValidator;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.CurrentEstimateValidator;
import com.atlassian.jira.jql.validator.IssueIdValidator;
import com.atlassian.jira.jql.validator.IssueParentValidator;
import com.atlassian.jira.jql.validator.IssueSecurityLevelClauseValidator;
import com.atlassian.jira.jql.validator.OperatorUsageValidator;
import com.atlassian.jira.jql.validator.OriginalEstimateValidator;
import com.atlassian.jira.jql.validator.ProjectCategoryValidator;
import com.atlassian.jira.jql.validator.SavedFilterClauseValidator;
import com.atlassian.jira.jql.validator.TimeSpentValidator;
import com.atlassian.jira.jql.validator.UserCustomFieldValidator;
import com.atlassian.jira.jql.validator.VotesValidator;
import com.atlassian.jira.jql.validator.WatchesValidator;
import com.atlassian.jira.jql.values.ProjectCategoryClauseValuesGenerator;
import com.atlassian.jira.jql.values.SavedFilterValuesGenerator;
import com.atlassian.jira.jql.values.SecurityLevelClauseValuesGenerator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import net.jcip.annotations.GuardedBy;

public class DefaultSystemClauseHandlerFactory
implements SystemClauseHandlerFactory {
    private final ComponentLocator locator;
    private final ComponentFactory factory;
    private final FieldClausePermissionChecker.Factory fieldClausePermissionHandlerFactory;
    @GuardedBy(value="this")
    private Collection<SearchHandler> systemClauseSearchHandlers = null;

    public DefaultSystemClauseHandlerFactory(ComponentLocator locator, ComponentFactory factory, FieldClausePermissionChecker.Factory fieldClausePermissionHandlerFactory) {
        this.factory = Assertions.notNull("factory", factory);
        this.locator = Assertions.notNull("locator", locator);
        this.fieldClausePermissionHandlerFactory = Assertions.notNull("fieldClausePermissionHandlerFactory", fieldClausePermissionHandlerFactory);
    }

    @Override
    public synchronized Collection<SearchHandler> getSystemClauseSearchHandlers() {
        if (this.systemClauseSearchHandlers == null) {
            this.systemClauseSearchHandlers = CollectionBuilder.list(this.createSavedFilterSearchHandler(), this.createIssueKeySearchHandler(), this.createIssueParentSearchHandler(), this.createCurrentEstimateSearchHandler(), this.createOriginalEstimateSearchHandler(), this.createTimeSpentSearchHandler(), this.createSecurityLevelSearchHandler(), this.createVotesSearchHandler(), this.createVoterSearchHandler(), this.createWatchesSearchHandler(), this.createWatcherSearchHandler(), this.createAllTextSearchHandler(), this.createProjectCategoryHandler(), this.createSubTaskSearchHandler(), this.createProgressSearchHandler());
        }
        return this.systemClauseSearchHandlers;
    }

    private SearchHandler createSavedFilterSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(SavedFilterClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(SavedFilterClauseValidator.class);
        ClauseContextFactory clauseContextFactory = this.locator.getComponentInstanceOfType(SavedFilterClauseContextFactory.class);
        DefaultValuesGeneratingClauseHandler savedFilterClauseHandler = new DefaultValuesGeneratingClauseHandler(SystemSearchConstants.forSavedFilter(), clauseFactory, clauseValidator, this.createNoOpClausePermissionHandler(), this.decorateWithValidatingContextFactory(clauseContextFactory), new SavedFilterValuesGenerator(this.locator.getComponentInstanceOfType(SearchRequestService.class)));
        SearchHandler.ClauseRegistration savedFilterClauseRegistration = new SearchHandler.ClauseRegistration(savedFilterClauseHandler);
        return new SearchHandler(Collections.<FieldIndexer>emptyList(), null, Collections.singletonList(savedFilterClauseRegistration));
    }

    private SearchHandler createIssueKeySearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(IssueIdClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(IssueIdValidator.class);
        IssueIdClauseContextFactory.Factory contextCreator = this.locator.getComponentInstanceOfType(IssueIdClauseContextFactory.Factory.class);
        ClauseContextFactory clauseContextFactory = this.decorateWithMultiContextFactory(contextCreator.create(true));
        ClausePermissionHandler clausePermissionHandler = this.createNoOpClausePermissionHandler(this.factory.createObject(IssueClauseValueSanitiser.class));
        DefaultClauseHandler issueKeySearchHandler = new DefaultClauseHandler(SystemSearchConstants.forIssueKey(), clauseFactory, clauseValidator, clausePermissionHandler, clauseContextFactory);
        SearchHandler.ClauseRegistration savedFilterClauseRegistration = new SearchHandler.ClauseRegistration(issueKeySearchHandler);
        CollectionBuilder<FieldIndexer> builder = CollectionBuilder.newBuilder(this.factory.createObject(IssueKeyIndexer.class), this.factory.createObject(IssueIdIndexer.class));
        return new SearchHandler(builder.asList(), null, Collections.singletonList(savedFilterClauseRegistration));
    }

    private SearchHandler createSubTaskSearchHandler() {
        String fieldId = "subtasks";
        SubTaskManager subTaskManager = this.locator.getComponentInstanceOfType(SubTaskManager.class);
        DefaultClausePermissionHandler clausePermissionHandler = new DefaultClausePermissionHandler(new IssueParentPermissionChecker(subTaskManager));
        NoOpClauseHandler noOpClauseHandler = new NoOpClauseHandler(clausePermissionHandler, "subtasks", new ClauseNames("subtasks"), "jira.jql.validation.field.not.searchable");
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration(noOpClauseHandler);
        return new SearchHandler(Collections.<FieldIndexer>emptyList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createProgressSearchHandler() {
        String fieldId = "progress";
        NoOpClauseHandler noOpClauseHandler = new NoOpClauseHandler(this.createTimeTrackingPermissionHandler(), "progress", new ClauseNames("progress"), "jira.jql.validation.field.not.searchable");
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration(noOpClauseHandler);
        return new SearchHandler(Collections.<FieldIndexer>emptyList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createIssueParentSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(IssueParentClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(IssueParentValidator.class);
        IssueIdClauseContextFactory.Factory contextCreator = this.locator.getComponentInstanceOfType(IssueIdClauseContextFactory.Factory.class);
        ClauseContextFactory clauseContextFactory = this.decorateWithMultiContextFactory(contextCreator.create(false));
        SubTaskManager subTaskManager = this.locator.getComponentInstanceOfType(SubTaskManager.class);
        DefaultClausePermissionHandler clausePermissionHandler = new DefaultClausePermissionHandler(new IssueParentPermissionChecker(subTaskManager), this.factory.createObject(IssueClauseValueSanitiser.class));
        DefaultClauseHandler issueKeySearchHandler = new DefaultClauseHandler(SystemSearchConstants.forIssueParent(), clauseFactory, clauseValidator, clausePermissionHandler, clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration(issueKeySearchHandler);
        return new SearchHandler(Collections.singletonList(this.factory.createObject(ParentIssueIndexer.class)), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createCurrentEstimateSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(CurrentEstimateClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(CurrentEstimateValidator.class);
        SimpleClauseContextFactory clauseContextFactory = new SimpleClauseContextFactory();
        DefaultClauseHandler currentEstimateClauseHandler = new DefaultClauseHandler(SystemSearchConstants.forCurrentEstimate(), clauseFactory, clauseValidator, this.createTimeTrackingPermissionHandler(), clauseContextFactory);
        SearchHandler.ClauseRegistration currentEstimateClauseRegistration = new SearchHandler.ClauseRegistration(currentEstimateClauseHandler);
        CollectionBuilder<FieldIndexer> builder = CollectionBuilder.newBuilder(this.factory.createObject(CurrentEstimateIndexer.class));
        return new SearchHandler(builder.asList(), null, Collections.singletonList(currentEstimateClauseRegistration));
    }

    private SearchHandler createOriginalEstimateSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(OriginalEstimateClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(OriginalEstimateValidator.class);
        SimpleClauseContextFactory clauseContextFactory = new SimpleClauseContextFactory();
        DefaultClauseHandler originalEstimateClauseHandler = new DefaultClauseHandler(SystemSearchConstants.forOriginalEstimate(), clauseFactory, clauseValidator, this.createTimeTrackingPermissionHandler(), clauseContextFactory);
        SearchHandler.ClauseRegistration originalEstimateClauseRegistration = new SearchHandler.ClauseRegistration(originalEstimateClauseHandler);
        CollectionBuilder<FieldIndexer> builder = CollectionBuilder.newBuilder(this.factory.createObject(OriginalEstimateIndexer.class));
        return new SearchHandler(builder.asList(), null, Collections.singletonList(originalEstimateClauseRegistration));
    }

    private SearchHandler createTimeSpentSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(TimeSpentClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(TimeSpentValidator.class);
        SimpleClauseContextFactory clauseContextFactory = new SimpleClauseContextFactory();
        DefaultClauseHandler timeSpentClauseHandler = new DefaultClauseHandler(SystemSearchConstants.forTimeSpent(), clauseFactory, clauseValidator, this.createTimeTrackingPermissionHandler(), clauseContextFactory);
        SearchHandler.ClauseRegistration timeSpentClauseRegistration = new SearchHandler.ClauseRegistration(timeSpentClauseHandler);
        CollectionBuilder<FieldIndexer> builder = CollectionBuilder.newBuilder(this.factory.createObject(TimeSpentIndexer.class));
        return new SearchHandler(builder.asList(), null, Collections.singletonList(timeSpentClauseRegistration));
    }

    private SearchHandler createSecurityLevelSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(IssueSecurityLevelClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(IssueSecurityLevelClauseValidator.class);
        IssueSecurityLevelManager issueSecurityLevelManager = this.locator.getComponentInstanceOfType(IssueSecurityLevelManager.class);
        IssueSecurityLevelClauseContextFactory.Creator issueSecurityLevelClauseContextFactoryCreator = this.locator.getComponentInstanceOfType(IssueSecurityLevelClauseContextFactory.Creator.class);
        IssueSecurityLevelClauseContextFactory clauseContextFactory = issueSecurityLevelClauseContextFactoryCreator.create();
        DefaultValuesGeneratingClauseHandler securityLevelClauseHandler = new DefaultValuesGeneratingClauseHandler(SystemSearchConstants.forSecurityLevel(), clauseFactory, clauseValidator, this.createClausePermissionHandler(SystemSearchConstants.forSecurityLevel().getFieldId()), this.decorateWithMultiContextFactory(clauseContextFactory), new SecurityLevelClauseValuesGenerator(issueSecurityLevelManager));
        SearchHandler.ClauseRegistration securityLevelClauseRegistration = new SearchHandler.ClauseRegistration(securityLevelClauseHandler);
        CollectionBuilder<FieldIndexer> builder = CollectionBuilder.newBuilder(this.factory.createObject(SecurityIndexer.class));
        return new SearchHandler(builder.asList(), null, Collections.singletonList(securityLevelClauseRegistration));
    }

    private SearchHandler createVotesSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(VotesClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(VotesValidator.class);
        ClauseContextFactory clauseContextFactory = this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
        VoteManager voteManager = this.locator.getComponentInstanceOfType(VoteManager.class);
        DefaultClauseHandler votesClauseHandler = new DefaultClauseHandler(SystemSearchConstants.forVotes(), clauseFactory, clauseValidator, new DefaultClausePermissionHandler(new VotePermissionChecker(voteManager)), clauseContextFactory);
        SearchHandler.ClauseRegistration votesClauseRegistration = new SearchHandler.ClauseRegistration(votesClauseHandler);
        CollectionBuilder<FieldIndexer> builder = CollectionBuilder.newBuilder(this.factory.createObject(VotesIndexer.class));
        return new SearchHandler(builder.asList(), null, Collections.singletonList(votesClauseRegistration));
    }

    private SearchHandler createVoterSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(VoterClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(UserCustomFieldValidator.class);
        ClauseContextFactory clauseContextFactory = this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
        VoteManager voteManager = this.locator.getComponentInstanceOfType(VoteManager.class);
        DefaultClauseHandler clauseHandler = new DefaultClauseHandler(SystemSearchConstants.forVoters(), clauseFactory, clauseValidator, new DefaultClausePermissionHandler(new VotePermissionChecker(voteManager)), clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration(clauseHandler);
        CollectionBuilder<FieldIndexer> builder = CollectionBuilder.newBuilder(this.factory.createObject(VoterIndexer.class));
        return new SearchHandler(builder.asList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createWatchesSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(WatchesClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(WatchesValidator.class);
        ClauseContextFactory clauseContextFactory = this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
        WatcherManager watcherManager = this.locator.getComponentInstanceOfType(WatcherManager.class);
        DefaultClauseHandler clauseHandler = new DefaultClauseHandler(SystemSearchConstants.forWatches(), clauseFactory, clauseValidator, new DefaultClausePermissionHandler(new WatchPermissionChecker(watcherManager)), clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration(clauseHandler);
        CollectionBuilder<FieldIndexer> builder = CollectionBuilder.newBuilder(this.factory.createObject(WatcherIndexer.class));
        return new SearchHandler(builder.asList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createWatcherSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(WatcherClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(UserCustomFieldValidator.class);
        ClauseContextFactory clauseContextFactory = this.locator.getComponentInstanceOfType(SimpleClauseContextFactory.class);
        WatcherManager watcherManager = this.locator.getComponentInstanceOfType(WatcherManager.class);
        DefaultClauseHandler clauseHandler = new DefaultClauseHandler(SystemSearchConstants.forWatchers(), clauseFactory, clauseValidator, new DefaultClausePermissionHandler(new WatchPermissionChecker(watcherManager)), clauseContextFactory);
        SearchHandler.ClauseRegistration clauseRegistration = new SearchHandler.ClauseRegistration(clauseHandler);
        CollectionBuilder<FieldIndexer> builder = CollectionBuilder.newBuilder(this.factory.createObject(WatcherIndexer.class));
        return new SearchHandler(builder.asList(), null, Collections.singletonList(clauseRegistration));
    }

    private SearchHandler createAllTextSearchHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(AllTextClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(AllTextValidator.class);
        ClauseContextFactory clauseContextFactory = this.locator.getComponentInstanceOfType(AllTextClauseContextFactory.class);
        DefaultClauseHandler allTextClauseHandler = new DefaultClauseHandler(SystemSearchConstants.forAllText(), clauseFactory, clauseValidator, new DefaultClausePermissionHandler(NoOpClausePermissionChecker.NOOP_CLAUSE_PERMISSION_CHECKER), clauseContextFactory);
        SearchHandler.ClauseRegistration allTextClauseRegistration = new SearchHandler.ClauseRegistration(allTextClauseHandler);
        return new SearchHandler(Collections.<FieldIndexer>emptyList(), null, Collections.singletonList(allTextClauseRegistration));
    }

    private SearchHandler createProjectCategoryHandler() {
        ClauseQueryFactory clauseFactory = this.locator.getComponentInstanceOfType(ProjectCategoryClauseQueryFactory.class);
        ClauseValidator clauseValidator = this.locator.getComponentInstanceOfType(ProjectCategoryValidator.class);
        ProjectManager projectManager = this.locator.getComponentInstanceOfType(ProjectManager.class);
        ClauseContextFactory clauseContextFactory = this.locator.getComponentInstanceOfType(ProjectCategoryClauseContextFactory.class);
        DefaultValuesGeneratingClauseHandler projectCategoryClauseHandler = new DefaultValuesGeneratingClauseHandler(SystemSearchConstants.forProjectCategory(), clauseFactory, clauseValidator, this.createNoOpClausePermissionHandler(), this.decorateWithMultiContextFactory(clauseContextFactory), new ProjectCategoryClauseValuesGenerator(projectManager));
        SearchHandler.ClauseRegistration projectCategoryClauseRegistration = new SearchHandler.ClauseRegistration(projectCategoryClauseHandler);
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        return new SearchHandler(builder.asList(), null, Collections.singletonList(projectCategoryClauseRegistration));
    }

    private ClausePermissionHandler createTimeTrackingPermissionHandler() {
        ApplicationProperties applicationProperties = this.locator.getComponentInstanceOfType(ApplicationProperties.class);
        return new DefaultClausePermissionHandler(new TimeTrackingPermissionChecker(this.fieldClausePermissionHandlerFactory, applicationProperties));
    }

    private ClausePermissionHandler createClausePermissionHandler(String fieldId) {
        return new DefaultClausePermissionHandler(this.fieldClausePermissionHandlerFactory.createPermissionChecker(fieldId));
    }

    private ClausePermissionHandler createNoOpClausePermissionHandler() {
        return new DefaultClausePermissionHandler(NoOpClausePermissionChecker.NOOP_CLAUSE_PERMISSION_CHECKER);
    }

    private ClausePermissionHandler createNoOpClausePermissionHandler(ClauseSanitiser sanitiser) {
        return new DefaultClausePermissionHandler(NoOpClausePermissionChecker.NOOP_CLAUSE_PERMISSION_CHECKER, sanitiser);
    }

    private ClauseContextFactory decorateWithMultiContextFactory(ClauseContextFactory factory) {
        MultiClauseDecoratorContextFactory.Factory multiFactory = this.locator.getComponentInstanceOfType(MultiClauseDecoratorContextFactory.Factory.class);
        return multiFactory.create(factory);
    }

    private ClauseContextFactory decorateWithValidatingContextFactory(ClauseContextFactory factory) {
        return new ValidatingDecoratorContextFactory(this.locator.getComponentInstanceOfType(OperatorUsageValidator.class), factory);
    }
}

