/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutStorageException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.sharing.IndexableSharedEntity;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.index.SharedEntityIndexer;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.Consumer;
import com.atlassian.jira.util.Resolver;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import java.util.Collection;
import java.util.Collections;
import org.ofbiz.core.entity.GenericValue;

public class DefaultSearchRequestManager
implements SearchRequestManager {
    private final ColumnLayoutManager columnLayoutManager;
    private final SubscriptionManager subscriptionManager;
    private final ShareManager shareManager;
    private final SearchRequestStore searchRequestStore;
    private final SharedEntityIndexer indexer;
    private final SearchService searchService;
    private final UserUtil userUtil;
    private final Resolver<SearchRequest, SearchRequest> searchRequestPermissionsResolver = new Resolver<SearchRequest, SearchRequest>(){

        @Override
        public SearchRequest get(SearchRequest request) {
            return DefaultSearchRequestManager.this.setSharePermissions(request);
        }
    };
    private final Resolver<IndexableSharedEntity<SearchRequest>, SharedEntity> sharedEntityPermissionsResolver = new Resolver<IndexableSharedEntity<SearchRequest>, SharedEntity>(){

        @Override
        public SharedEntity get(IndexableSharedEntity<SearchRequest> entity) {
            return DefaultSearchRequestManager.this.setSharePermissions(entity);
        }
    };

    public DefaultSearchRequestManager(ColumnLayoutManager columnLayoutManager, SubscriptionManager subscriptionManager, ShareManager shareManager, SearchRequestStore searchRequestStore, SharedEntityIndexer indexer, SearchService searchService, UserUtil userUtil) {
        this.columnLayoutManager = Assertions.notNull("columnLayoutManager", columnLayoutManager);
        this.subscriptionManager = Assertions.notNull("subscriptionManager", subscriptionManager);
        this.shareManager = Assertions.notNull("shareManager", shareManager);
        this.searchRequestStore = Assertions.notNull("searchRequestStore", searchRequestStore);
        this.indexer = Assertions.notNull("indexer", indexer);
        this.searchService = Assertions.notNull("searchService", searchService);
        this.userUtil = Assertions.notNull("userUtil", userUtil);
    }

    @Override
    public EnclosedIterable<SearchRequest> get(SharedEntityAccessor.RetrievalDescriptor descriptor) {
        return Transformed.enclosedIterable(this.searchRequestStore.get(descriptor), this.searchRequestPermissionsResolver);
    }

    @Override
    public EnclosedIterable<SearchRequest> get(User user, SharedEntityAccessor.RetrievalDescriptor descriptor) {
        return Transformed.enclosedIterable(this.searchRequestStore.get(descriptor), this.createPermissionSanitisingResolver(user));
    }

    @Override
    public EnclosedIterable<SearchRequest> getAll() {
        return Transformed.enclosedIterable(this.searchRequestStore.getAll(), this.searchRequestPermissionsResolver);
    }

    @Override
    public EnclosedIterable<SharedEntity> getAllIndexableSharedEntities() {
        return Transformed.enclosedIterable(this.searchRequestStore.getAllIndexableSharedEntities(), this.sharedEntityPermissionsResolver);
    }

    @Override
    public Collection<SearchRequest> getAllOwnedSearchRequests(User user) {
        Collection<SearchRequest> searchRequests = this.searchRequestStore.getAllOwnedSearchRequests(user);
        if (searchRequests == null) {
            return Collections.emptyList();
        }
        return CollectionUtil.transform(searchRequests.iterator(), this.createPermissionSanitisingResolver(user));
    }

    @Override
    public SearchRequest getOwnedSearchRequestByName(User author, String name) {
        Assertions.notNull("name", name);
        SearchRequest searchRequest = this.searchRequestStore.getRequestByAuthorAndName(author, name);
        return this.setSanitisedQuery(author, this.setSharePermissions(searchRequest));
    }

    @Override
    public SearchRequest getSearchRequestById(User user, Long id) {
        Assertions.notNull("id", id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null && this.isSharedWith(searchRequest, user)) {
            return this.setSanitisedQuery(user, this.setSharePermissions(searchRequest));
        }
        return null;
    }

    @Override
    public String getSearchRequestOwnerUserName(Long id) {
        Assertions.notNull("id", id);
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(id);
        if (searchRequest != null) {
            return searchRequest.getOwnerUserName();
        }
        return null;
    }

    @Override
    public SearchRequest create(SearchRequest request) {
        this.validateSearchRequestCreate(request);
        SearchRequest searchRequest = this.searchRequestStore.create(request);
        searchRequest.setPermissions(request.getPermissions());
        searchRequest.setPermissions(this.shareManager.updateSharePermissions(searchRequest));
        this.indexer.index(searchRequest).await();
        return this.setSanitisedQuery(this.userUtil.getUserObject(searchRequest.getOwnerUserName()), searchRequest);
    }

    @Override
    public SearchRequest update(SearchRequest request) {
        this.validateSearchRequestUpdate(request);
        SearchRequest searchRequest = this.searchRequestStore.update(request);
        searchRequest.setPermissions(this.shareManager.updateSharePermissions(request));
        this.indexer.index(searchRequest).await();
        return this.setSanitisedQuery(this.userUtil.getUserObject(searchRequest.getOwnerUserName()), searchRequest);
    }

    @Override
    public void delete(Long id) {
        SearchRequest searchRequest = this.searchRequestStore.getSearchRequest(Assertions.notNull("id", id));
        if (searchRequest != null) {
            this.deleteSearchRequest(searchRequest);
        }
    }

    private void deleteSearchRequest(SearchRequest searchRequest) {
        try {
            CollectionUtil.foreach(this.subscriptionManager.getAllSubscriptions(searchRequest.getId()), new Consumer<GenericValue>(){

                @Override
                public void consume(GenericValue subscription) {
                    try {
                        DefaultSearchRequestManager.this.subscriptionManager.deleteSubscription(subscription.getLong("id"));
                    }
                    catch (Exception e) {
                        throw new DataAccessException("Error occurred while deleting searchRequest.", e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new DataAccessException("Error occurred while deleting searchRequest.", e);
        }
        try {
            if (this.columnLayoutManager.hasColumnLayout(searchRequest)) {
                this.columnLayoutManager.restoreSearchRequestColumnLayout(searchRequest);
            }
        }
        catch (ColumnLayoutStorageException e) {
            throw new DataAccessException("Error occurred while deleting searchRequest.", e);
        }
        this.shareManager.deletePermissions(searchRequest);
        this.searchRequestStore.delete(searchRequest.getId());
        this.indexer.deIndex(searchRequest).await();
    }

    @Override
    public SharedEntity.TypeDescriptor<SearchRequest> getType() {
        return SearchRequest.ENTITY_TYPE;
    }

    @Override
    public void adjustFavouriteCount(SharedEntity entity, int adjustmentValue) {
        Assertions.notNull("entity", entity);
        Assertions.equals("SearchRequestManager can only adjust favourite counts for Search Requests.", SearchRequest.ENTITY_TYPE, entity.getEntityType());
        SearchRequest searchRequest = this.searchRequestStore.adjustFavouriteCount(entity.getId(), adjustmentValue);
        this.setSharePermissions(searchRequest);
        this.indexer.index(searchRequest).await();
    }

    SearchRequest setSanitisedQuery(User searcher, SearchRequest filter) {
        Query sanitisedQuery;
        Query query;
        if (filter != null && !(query = filter.getQuery()).equals(sanitisedQuery = this.searchService.sanitiseSearchQuery(searcher, query))) {
            boolean isModified = filter.isModified();
            filter.setQuery(sanitisedQuery);
            filter.setModified(isModified);
        }
        return filter;
    }

    private boolean isSharedWith(SearchRequest entity, User user) {
        return this.shareManager.isSharedWith(user, entity);
    }

    private SearchRequest setSharePermissions(SearchRequest filter) {
        if (filter != null) {
            filter.setPermissions(this.shareManager.getSharePermissions(filter));
        }
        return filter;
    }

    private SharedEntity setSharePermissions(IndexableSharedEntity<SearchRequest> entity) {
        if (entity != null) {
            entity.setPermissions(this.shareManager.getSharePermissions(entity));
        }
        return entity;
    }

    private void validateSearchRequestCreate(SearchRequest request) {
        Assertions.notNull("request", request);
        Assertions.notNull("request.owner.user.name", request.getOwnerUserName());
        Assertions.notNull("request.name", request.getName());
    }

    private void validateSearchRequestUpdate(SearchRequest request) {
        this.validateSearchRequestCreate(request);
        Assertions.notNull("request.id", request.getId());
    }

    @Override
    public SharedEntitySearchResult<SearchRequest> search(SharedEntitySearchParameters searchParameters, User user, int pagePosition, int pageWidth) {
        Assertions.notNull("searchParameters", searchParameters);
        Assertions.not("pagePosition < 0", pagePosition < 0);
        Assertions.not("pageWidth <= 0", pageWidth <= 0);
        return this.indexer.getSearcher(SearchRequest.ENTITY_TYPE).search(searchParameters, user, pagePosition, pageWidth);
    }

    @Override
    public SearchRequest getSharedEntity(Long entityId) {
        Assertions.notNull("entityId", entityId);
        return this.setSharePermissions(this.searchRequestStore.getSearchRequest(entityId));
    }

    @Override
    public SearchRequest getSharedEntity(User user, Long entityId) {
        Assertions.notNull("entityId", entityId);
        return this.getSearchRequestById(user, entityId);
    }

    @Override
    public boolean hasPermissionToUse(User user, SearchRequest entity) {
        Assertions.notNull("entity", entity);
        Assertions.equals("SearchRequestManager can only adjust favourite counts for Search Requests.", SearchRequest.ENTITY_TYPE, entity.getEntityType());
        return this.shareManager.isSharedWith(user, entity);
    }

    private Resolver<SearchRequest, SearchRequest> createPermissionSanitisingResolver(final User searcher) {
        return new Resolver<SearchRequest, SearchRequest>(){

            @Override
            public SearchRequest get(SearchRequest request) {
                return DefaultSearchRequestManager.this.setSanitisedQuery(searcher, DefaultSearchRequestManager.this.setSharePermissions(request));
            }
        };
    }
}

