/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestFactory;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.util.SearchSortUtil;
import com.atlassian.jira.issue.transport.ActionParams;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.issue.transport.impl.FieldValuesHolderImpl;
import com.atlassian.jira.jql.clause.SimpleEquivalenceComparator;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DefaultSearchRequestFactory
implements SearchRequestFactory {
    private final IssueSearcherManager issueSearcherManager;
    private final SearchSortUtil searchSortUtil;
    private final SearchService searchService;

    public DefaultSearchRequestFactory(IssueSearcherManager issueSearcherManager, SearchSortUtil searchSortUtil, SearchService searchService) {
        this.issueSearcherManager = issueSearcherManager;
        this.searchSortUtil = searchSortUtil;
        this.searchService = searchService;
    }

    @Override
    public SearchRequest createFromParameters(SearchRequest oldSearchRequest, User searchUser, ActionParams actionParameters) {
        Assertions.notNull("actionParameters", actionParameters);
        List<Clause> clauses = this.getClausesFromSearchers(searchUser, actionParameters);
        Clause clause = this.getClause(clauses);
        List<SearchSort> combinedSorts = this.combineSorts(oldSearchRequest, searchUser, actionParameters);
        QueryImpl newQuery = new QueryImpl(clause, new OrderByImpl(combinedSorts), null);
        SearchRequest newSearchRequest = this.createNewSearchRequest(oldSearchRequest, searchUser);
        newSearchRequest.setQuery(newQuery);
        if (oldSearchRequest != null) {
            boolean modified;
            boolean bl = modified = !this.simpleSearchRequestsSameOrQueriesEquivalent(searchUser, oldSearchRequest, newSearchRequest);
            if (!modified) {
                newSearchRequest.setQuery(oldSearchRequest.getQuery());
            }
            newSearchRequest.setModified(modified || oldSearchRequest.isModified());
        } else {
            newSearchRequest.setModified(false);
        }
        return newSearchRequest;
    }

    @Override
    public SearchRequest createFromQuery(SearchRequest oldSearchRequest, User searchUser, Query query) {
        Assertions.notNull("query", query);
        SearchRequest searchRequest = this.createNewSearchRequest(oldSearchRequest, searchUser);
        searchRequest.setQuery(query);
        if (oldSearchRequest != null && (oldSearchRequest.isModified() || !this.searchRequestsSameOrQueriesEquivalent(oldSearchRequest, searchRequest))) {
            searchRequest.setModified(true);
        } else {
            searchRequest.setModified(false);
        }
        return searchRequest;
    }

    List<SearchSort> combineSorts(SearchRequest oldSearchRequest, User searchUser, ActionParams actionParameters) {
        List<SearchSort> oldSearchRequestSorts = null;
        if (oldSearchRequest != null && oldSearchRequest.getQuery().getOrderByClause() != null && !oldSearchRequest.getQuery().getOrderByClause().getSearchSorts().isEmpty()) {
            oldSearchRequestSorts = oldSearchRequest.getQuery().getOrderByClause().getSearchSorts();
        }
        OrderBy paramsOrderBy = this.searchSortUtil.getOrderByClause(actionParameters.getKeysAndValues());
        List<SearchSort> combinedSorts = paramsOrderBy.getSearchSorts();
        if (oldSearchRequestSorts != null) {
            combinedSorts = this.searchSortUtil.mergeSearchSorts(searchUser, combinedSorts, oldSearchRequestSorts, Integer.MAX_VALUE);
        }
        return combinedSorts;
    }

    SearchRequest createNewSearchRequest(SearchRequest oldSearchRequest, User searchUser) {
        SearchRequest searchRequest;
        if (oldSearchRequest != null && oldSearchRequest.isLoaded()) {
            searchRequest = new SearchRequest(oldSearchRequest);
        } else {
            searchRequest = new SearchRequest();
            searchRequest.setOwnerUserName(searchUser == null ? null : searchUser.getName());
        }
        return searchRequest;
    }

    boolean simpleSearchRequestsSameOrQueriesEquivalent(User user, SearchRequest oldSearchRequest, SearchRequest newSearchRequest) {
        if (!this.nonQueryAttributesEquals(newSearchRequest, oldSearchRequest)) {
            return false;
        }
        Query oldQuery = oldSearchRequest.getQuery();
        Query query = newSearchRequest.getQuery();
        return this.checkOrderByClauses(oldQuery.getOrderByClause(), query.getOrderByClause()) && this.checkSimpleWhereClauses(user, oldSearchRequest.getQuery(), newSearchRequest.getQuery());
    }

    private boolean checkSimpleWhereClauses(User user, Query oldQuery, Query newQuery) {
        SearchContext oldSearchContext;
        QueryContext oldQueryContext;
        QueryContext newQueryContext = this.searchService.getQueryContext(user, newQuery);
        if (!newQueryContext.equals(oldQueryContext = this.searchService.getQueryContext(user, oldQuery))) {
            return false;
        }
        SearchContext newSearchContext = this.searchService.getSearchContext(user, newQuery);
        if (!newSearchContext.equals(oldSearchContext = this.searchService.getSearchContext(user, oldQuery))) {
            return false;
        }
        FieldValuesHolderImpl oldHolder = new FieldValuesHolderImpl();
        FieldValuesHolderImpl newHolder = new FieldValuesHolderImpl();
        Collection<IssueSearcher<?>> issueSearchers = this.issueSearcherManager.getAllSearchers();
        for (IssueSearcher<?> issueSearcher : issueSearchers) {
            oldHolder.clear();
            newHolder.clear();
            issueSearcher.getSearchInputTransformer().populateFromQuery(user, newHolder, newQuery, newSearchContext);
            issueSearcher.getSearchInputTransformer().populateFromQuery(user, oldHolder, oldQuery, oldSearchContext);
            if (this.holdersEqual(oldHolder, newHolder)) continue;
            return false;
        }
        return true;
    }

    boolean searchRequestsSameOrQueriesEquivalent(SearchRequest oldSearchRequest, SearchRequest searchRequest) {
        if (!this.nonQueryAttributesEquals(searchRequest, oldSearchRequest)) {
            return false;
        }
        if (oldSearchRequest.getQuery().getQueryString() != null && searchRequest.getQuery().getQueryString() != null) {
            return oldSearchRequest.getQuery().getQueryString().equals(searchRequest.getQuery().getQueryString());
        }
        return this.checkOrderByClauses(oldSearchRequest.getQuery().getOrderByClause(), searchRequest.getQuery().getOrderByClause()) && this.checkWhereClauses(oldSearchRequest.getQuery().getWhereClause(), searchRequest.getQuery().getWhereClause());
    }

    boolean nonQueryAttributesEquals(SearchRequest searchRequest, SearchRequest otherSearchRequest) {
        if (searchRequest == null && otherSearchRequest == null) {
            return true;
        }
        if (searchRequest == null || otherSearchRequest == null) {
            return false;
        }
        if (searchRequest == otherSearchRequest) {
            return true;
        }
        if (otherSearchRequest.getOwnerUserName() != null ? !otherSearchRequest.getOwnerUserName().equals(searchRequest.getOwnerUserName()) : searchRequest.getOwnerUserName() != null) {
            return false;
        }
        if (otherSearchRequest.getDescription() != null ? !otherSearchRequest.getDescription().equals(searchRequest.getDescription()) : searchRequest.getDescription() != null) {
            return false;
        }
        if (otherSearchRequest.isLoaded() != searchRequest.isLoaded()) {
            return false;
        }
        return !(otherSearchRequest.getName() != null ? !otherSearchRequest.getName().equals(searchRequest.getName()) : searchRequest.getName() != null);
    }

    boolean checkWhereClauses(Clause oldWhereClause, Clause newWhereClause) {
        if (oldWhereClause == null && newWhereClause == null) {
            return true;
        }
        if (oldWhereClause == null || newWhereClause == null) {
            return false;
        }
        return this.checkClauseEquivalence(oldWhereClause, newWhereClause);
    }

    boolean checkOrderByClauses(OrderBy oldOrderByClause, OrderBy newOrderByClause) {
        if (oldOrderByClause == null && newOrderByClause == null) {
            return true;
        }
        if (oldOrderByClause == null || newOrderByClause == null) {
            return false;
        }
        return oldOrderByClause.equals(newOrderByClause);
    }

    boolean holdersEqual(FieldValuesHolder oldHolder, FieldValuesHolder newHolder) {
        return newHolder.equals(oldHolder);
    }

    boolean checkClauseEquivalence(Clause oldClause, Clause clause) {
        return new SimpleEquivalenceComparator().isEquivalent(oldClause, clause);
    }

    List<Clause> getClausesFromSearchers(User searchUser, ActionParams actionParams) {
        FieldValuesHolderImpl fieldValuesHolder = new FieldValuesHolderImpl();
        Collection<IssueSearcher<?>> searchers = this.issueSearcherManager.getAllSearchers();
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (IssueSearcher<?> searcher : searchers) {
            SearchInputTransformer searchInputTransformer = searcher.getSearchInputTransformer();
            searchInputTransformer.populateFromParams(searchUser, fieldValuesHolder, actionParams);
            Clause clause = searchInputTransformer.getSearchClause(searchUser, fieldValuesHolder);
            if (clause == null) continue;
            clauses.add(clause);
        }
        return clauses;
    }

    Clause getClause(List<Clause> clauses) {
        Clause clause = !clauses.isEmpty() ? (clauses.size() == 1 ? clauses.get(0) : new AndClause(clauses)) : null;
        return clause;
    }
}

