/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAdminManager;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.search.SearchRequestStore;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;

public class DefaultSearchRequestAdminManager
implements SearchRequestAdminManager {
    private final ShareManager shareManager;
    private final SearchRequestStore searchRequestStore;
    private final SearchRequestManager searchRequestManager;

    public DefaultSearchRequestAdminManager(SearchRequestStore searchRequestStore, SearchRequestManager searchRequestManager, ShareManager shareManager) {
        this.searchRequestStore = searchRequestStore;
        this.searchRequestManager = searchRequestManager;
        this.shareManager = shareManager;
    }

    public EnclosedIterable getSearchRequests(Project project) {
        Assertions.notNull("project", project);
        return this.searchRequestStore.getSearchRequests(project);
    }

    public EnclosedIterable getSearchRequests(Group group) {
        Assertions.notNull("group", group);
        return this.searchRequestStore.getSearchRequests(group);
    }

    @Override
    public SearchRequest getSearchRequestById(Long id) {
        Assertions.notNull("id", id);
        return this.setSharePermissions(this.searchRequestStore.getSearchRequest(id));
    }

    @Override
    public SearchRequest update(SearchRequest request) {
        return this.searchRequestManager.update(request);
    }

    @Override
    public void delete(Long searchRequestId) {
        this.searchRequestManager.delete(searchRequestId);
    }

    private SearchRequest setSharePermissions(SearchRequest filter) {
        if (filter != null) {
            filter.setPermissions(this.shareManager.getSharePermissions(filter));
        }
        return filter;
    }
}

