/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.ArrayList;
import java.util.List;

public class ClauseReplacingCloningVisitor
implements ClauseVisitor<Clause> {
    private final List<TerminalClause> substitutions;

    public ClauseReplacingCloningVisitor(List<TerminalClause> substitutions) {
        this.substitutions = substitutions;
    }

    @Override
    public Clause visit(AndClause andClause) {
        ArrayList<Clause> subClauses = new ArrayList<Clause>();
        for (Clause clause : andClause.getClauses()) {
            subClauses.add(clause.accept(this));
        }
        return new AndClause(subClauses);
    }

    @Override
    public Clause visit(NotClause notClause) {
        Clause newSubClause = notClause.getSubClause().accept(this);
        return new NotClause(newSubClause);
    }

    @Override
    public Clause visit(OrClause orClause) {
        ArrayList<Clause> subClauses = new ArrayList<Clause>();
        for (Clause clause : orClause.getClauses()) {
            subClauses.add(clause.accept(this));
        }
        return new OrClause(subClauses);
    }

    @Override
    public Clause visit(TerminalClause clause) {
        if (this.substitutions != null) {
            for (TerminalClause substitution : this.substitutions) {
                if (!clause.getName().equalsIgnoreCase(substitution.getName())) continue;
                return substitution;
            }
        }
        return clause;
    }

    @Override
    public Clause visit(WasClause clause) {
        return clause;
    }

    @Override
    public Clause visit(ChangedClause clause) {
        return clause;
    }
}

