/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.ChangedClauseImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.clause.WasClauseImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ClauseRenamingCloningVisitor
implements ClauseVisitor<Clause> {
    private final Map<String, String> lowerCaseSubstitutions;

    public ClauseRenamingCloningVisitor(Map<String, String> substitutions) {
        Assertions.notNull("substitutions", substitutions);
        this.lowerCaseSubstitutions = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : substitutions.entrySet()) {
            this.lowerCaseSubstitutions.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    @Override
    public Clause visit(AndClause andClause) {
        ArrayList<Clause> subClauses = new ArrayList<Clause>();
        for (Clause clause : andClause.getClauses()) {
            subClauses.add(clause.accept(this));
        }
        return new AndClause(subClauses);
    }

    @Override
    public Clause visit(NotClause notClause) {
        Clause newSubClause = notClause.getSubClause().accept(this);
        return new NotClause(newSubClause);
    }

    @Override
    public Clause visit(OrClause orClause) {
        ArrayList<Clause> subClauses = new ArrayList<Clause>();
        for (Clause clause : orClause.getClauses()) {
            subClauses.add(clause.accept(this));
        }
        return new OrClause(subClauses);
    }

    @Override
    public Clause visit(TerminalClause clause) {
        String lowerCaseName = clause.getName().toLowerCase();
        if (this.lowerCaseSubstitutions.containsKey(lowerCaseName)) {
            return new TerminalClauseImpl(this.lowerCaseSubstitutions.get(lowerCaseName), clause.getOperator(), clause.getOperand());
        }
        return clause;
    }

    @Override
    public Clause visit(WasClause clause) {
        return new WasClauseImpl(clause);
    }

    @Override
    public Clause visit(ChangedClause clause) {
        return new ChangedClauseImpl(clause);
    }
}

