/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ClauseRemovingCloningVisitor
implements ClauseVisitor<Clause> {
    private final Set<String> clauseNamesToRemove;

    public ClauseRemovingCloningVisitor(List<String> clauseNamesToRemove) {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (clauseNamesToRemove != null) {
            names.addAll(clauseNamesToRemove);
        }
        this.clauseNamesToRemove = Collections.unmodifiableSet(names);
    }

    @Override
    public Clause visit(AndClause andClause) {
        ArrayList<Clause> subClauses = new ArrayList<Clause>();
        for (Clause clause : andClause.getClauses()) {
            Clause subClause = clause.accept(this);
            if (subClause == null) continue;
            subClauses.add(subClause);
        }
        if (subClauses.isEmpty()) {
            return null;
        }
        return new AndClause(subClauses);
    }

    @Override
    public Clause visit(NotClause notClause) {
        Clause newSubClause = notClause.getSubClause().accept(this);
        if (newSubClause == null) {
            return null;
        }
        return new NotClause(newSubClause);
    }

    @Override
    public Clause visit(OrClause orClause) {
        ArrayList<Clause> subClauses = new ArrayList<Clause>();
        for (Clause clause : orClause.getClauses()) {
            Clause subClause = clause.accept(this);
            if (subClause == null) continue;
            subClauses.add(subClause);
        }
        if (subClauses.isEmpty()) {
            return null;
        }
        return new OrClause(subClauses);
    }

    @Override
    public Clause visit(TerminalClause clause) {
        return this.removeClause(clause);
    }

    @Override
    public Clause visit(WasClause clause) {
        return this.removeClause(clause);
    }

    @Override
    public Clause visit(ChangedClause clause) {
        return this.removeClause(clause);
    }

    private Clause removeClause(Clause clause) {
        if (this.clauseNamesToRemove != null && this.clauseNamesToRemove.contains(clause.getName())) {
            return null;
        }
        return clause;
    }
}

