/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comparator.CustomFieldComparator;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldImpl;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.jql.context.FieldConfigSchemeClauseContextUtil;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericPK;
import org.ofbiz.core.entity.GenericValue;

@SuppressWarnings(value={"MT_CORRECTNESS"}, justification="TODO Needs to be fixed.")
public class DefaultCustomFieldManager
implements CustomFieldManager {
    private static final Logger log = Logger.getLogger(DefaultCustomFieldManager.class);
    private ConcurrentHashMap<Long, CustomField> allCustomFieldObjectsMapById;
    private MultiMap allCustomFieldObjectsMapByName;
    private List<CustomField> allCustomFieldObjectsList;
    private final PluginAccessor pluginAccessor;
    private final OfBizDelegator delegator;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsManager constantsManager;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final FieldConfigContextPersister contextPersister;
    private final FieldScreenManager fieldScreenManager;
    private final RendererManager rendererManager;
    private final CustomFieldValuePersister customFieldValuePersister;
    private final NotificationSchemeManager notificationSchemeManager;
    private final FieldManager fieldManager;
    private final FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil;

    public DefaultCustomFieldManager(PluginAccessor pluginAccessor, OfBizDelegator delegator, FieldConfigSchemeManager fieldConfigSchemeManager, JiraAuthenticationContext authenticationContext, ConstantsManager constantsManager, ProjectManager projectManager, PermissionManager permissionManager, FieldConfigContextPersister contextPersister, FieldScreenManager fieldScreenManager, RendererManager rendererManager, CustomFieldValuePersister customFieldValuePersister, NotificationSchemeManager notificationSchemeManager, FieldManager fieldManager, FieldConfigSchemeClauseContextUtil fieldConfigSchemeClauseContextUtil, EventPublisher eventPublisher) {
        this.pluginAccessor = pluginAccessor;
        this.delegator = delegator;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.authenticationContext = authenticationContext;
        this.constantsManager = constantsManager;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.contextPersister = contextPersister;
        this.fieldScreenManager = fieldScreenManager;
        this.rendererManager = rendererManager;
        this.customFieldValuePersister = customFieldValuePersister;
        this.notificationSchemeManager = notificationSchemeManager;
        this.fieldManager = fieldManager;
        this.fieldConfigSchemeClauseContextUtil = fieldConfigSchemeClauseContextUtil;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    public CustomField createCustomField(String fieldName, String description, CustomFieldType fieldType, CustomFieldSearcher customFieldSearcher, List contexts, List issueTypes) throws GenericEntityException {
        HashMap<String, String> createFields = new HashMap<String, String>();
        createFields.put("name", StringUtils.abbreviate((String)fieldName, (int)254));
        createFields.put("customfieldtypekey", fieldType.getKey());
        if (StringUtils.isNotEmpty((String)description)) {
            createFields.put("description", description);
        }
        if (customFieldSearcher != null) {
            createFields.put("customfieldsearcherkey", customFieldSearcher.getDescriptor().getCompleteKey());
        }
        GenericValue customFieldGV = EntityUtils.createValue("CustomField", createFields);
        CustomFieldImpl customField = new CustomFieldImpl(customFieldGV, this, this.authenticationContext, this.constantsManager, this.fieldConfigSchemeManager, this.permissionManager, this.rendererManager, this.fieldConfigSchemeClauseContextUtil);
        this.associateCustomFieldContext(customField, contexts, issueTypes);
        GenericDelegator genericDelegator = CoreFactory.getGenericDelegator();
        genericDelegator.clearCacheLineFlexible((GenericEntity)new GenericPK(genericDelegator.getModelEntity("CustomField")));
        this.refresh();
        this.fieldManager.refresh();
        return this.getCustomFieldObject(customFieldGV.getLong("id"));
    }

    public void associateCustomFieldContext(CustomField customField, List contexts, List issueTypes) {
        if (contexts != null && !contexts.isEmpty()) {
            this.fieldConfigSchemeManager.createDefaultScheme(customField, contexts, issueTypes);
        }
    }

    @Override
    public List getCustomFieldTypes() {
        List customFieldTypes = this.pluginAccessor.getEnabledModulesByClass(CustomFieldType.class);
        Collections.sort(customFieldTypes, new Comparator<CustomFieldType>(){

            @Override
            public int compare(CustomFieldType o1, CustomFieldType o2) {
                String name1 = o1.getName();
                String name2 = o2.getName();
                if (name1 == null) {
                    return name2 == null ? 0 : -1;
                }
                return name1.compareTo(name2);
            }
        });
        return customFieldTypes;
    }

    @Override
    public CustomFieldType getCustomFieldType(String key) {
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module != null && module instanceof CustomFieldTypeModuleDescriptor) {
            return (CustomFieldType)module.getModule();
        }
        log.error((Object)("Could not load custom field type plugin with key '" + key + "'. Is the plugin present and enabled?"));
        return null;
    }

    @Override
    public List<CustomFieldSearcher> getCustomFieldSearchers(CustomFieldType customFieldType) {
        List allFieldSearchers = this.pluginAccessor.getEnabledModulesByClass(CustomFieldSearcher.class);
        ArrayList<CustomFieldSearcher> customFieldSearchers = new ArrayList<CustomFieldSearcher>();
        for (CustomFieldSearcher searcher : allFieldSearchers) {
            if (!searcher.getDescriptor().getValidCustomFieldKeys().contains(customFieldType.getKey())) continue;
            customFieldSearchers.add(searcher);
        }
        return customFieldSearchers;
    }

    @Override
    public CustomFieldSearcher getCustomFieldSearcher(String key) {
        if (key == null) {
            return null;
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module != null && module instanceof CustomFieldSearcherModuleDescriptor) {
            Class searcherClazz = module.getModuleClass();
            CustomFieldSearcher cfSearcher = (CustomFieldSearcher)JiraUtils.loadComponent(searcherClazz);
            cfSearcher.init((CustomFieldSearcherModuleDescriptor)module);
            return cfSearcher;
        }
        log.warn((Object)("Custom field searcher module: " + key + " is invalid. Null being returned."));
        return null;
    }

    @Override
    public Class getCustomFieldSearcherClass(String key) {
        if (key == null) {
            return null;
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module != null && module instanceof CustomFieldSearcherModuleDescriptor) {
            return module.getModuleClass();
        }
        log.warn((Object)("Custom field searcher module: " + key + " is invalid. Null being returned."));
        return null;
    }

    @Override
    public List<CustomField> getCustomFieldObjects(Issue issue) {
        return this.getCustomFieldObjects(issue.getProjectObject().getId(), issue.getIssueTypeObject().getId());
    }

    @Override
    public List<CustomField> getCustomFieldObjects(GenericValue issue) {
        return this.getCustomFieldObjects(issue.getLong("project"), issue.getString("type"));
    }

    @Override
    public List<CustomField> getCustomFieldObjects(Long projectId, String issueTypeId) {
        ArrayList issueTypes = issueTypeId == null ? null : Lists.newArrayList((Object[])new String[]{issueTypeId});
        return this.getCustomFieldObjects(projectId, issueTypes);
    }

    @Override
    public List<CustomField> getCustomFieldObjects(Long projectId, List<String> issueTypeIds) {
        ArrayList<CustomField> customFieldsInContext = new ArrayList<CustomField>();
        Project project = this.projectManager.getProjectObj(projectId);
        issueTypeIds = this.constantsManager.expandIssueTypeIds(issueTypeIds);
        for (CustomField customField : this.getCustomFieldObjects()) {
            if (!customField.isInScope(project, issueTypeIds)) continue;
            customFieldsInContext.add(customField);
        }
        return customFieldsInContext;
    }

    @Override
    public List<CustomField> getCustomFieldObjects(SearchContext searchContext) {
        ArrayList<CustomField> customFieldsInContext = new ArrayList<CustomField>();
        for (CustomField customField : this.getCustomFieldObjects()) {
            if (!customField.isInScope(this.authenticationContext.getLoggedInUser(), searchContext)) continue;
            customFieldsInContext.add(customField);
        }
        return customFieldsInContext;
    }

    @Override
    public CustomField getCustomFieldObject(Long id) {
        this.ensureCacheLoaded();
        return this.allCustomFieldObjectsMapById.get(id);
    }

    @Override
    public CustomField getCustomFieldObject(String key) {
        Long id = CustomFieldUtils.getCustomFieldId(key);
        if (id != null) {
            return this.getCustomFieldObject(id);
        }
        return null;
    }

    @Override
    public CustomField getCustomFieldObjectByName(String customFieldName) {
        Collection<CustomField> values = this.getCustomFieldObjectsByName(customFieldName);
        if (values == null || values.size() == 0) {
            return null;
        }
        if (values.size() > 1) {
            log.warn((Object)("Warning: returning 1 of " + values.size() + " custom fields named '" + customFieldName + "'"));
            if (log.isDebugEnabled()) {
                Thread.dumpStack();
            }
        }
        return this.getCustomFieldObjectsByName(customFieldName).iterator().next();
    }

    @Override
    public Collection<CustomField> getCustomFieldObjectsByName(String customFieldName) {
        this.ensureCacheLoaded();
        return (Collection)this.allCustomFieldObjectsMapByName.get((Object)customFieldName);
    }

    @Override
    public List<CustomField> getCustomFieldObjects() {
        this.ensureCacheLoaded();
        return Collections.unmodifiableList(this.allCustomFieldObjectsList);
    }

    @Override
    public List<CustomField> getGlobalCustomFieldObjects() {
        this.ensureCacheLoaded();
        Collection global = CollectionUtils.select(this.allCustomFieldObjectsList, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                CustomField cf = (CustomField)object;
                return cf.isGlobal();
            }
        });
        return new ArrayList<CustomField>(global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCacheLoaded() {
        if (this.allCustomFieldObjectsMapById == null) {
            DefaultCustomFieldManager defaultCustomFieldManager = this;
            synchronized (defaultCustomFieldManager) {
                if (this.allCustomFieldObjectsMapById == null) {
                    this.populateCache();
                }
            }
        }
    }

    @Override
    public synchronized void refresh() {
        this.fieldConfigSchemeManager.init();
        this.populateCache();
        IssueSearcherManager issueSearcherManager = ComponentManager.getComponentInstanceOfType(IssueSearcherManager.class);
        issueSearcherManager.refresh();
        FieldIndexerManager fieldIndexerManager = ComponentManager.getComponentInstanceOfType(FieldIndexerManager.class);
        fieldIndexerManager.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        DefaultCustomFieldManager defaultCustomFieldManager = this;
        synchronized (defaultCustomFieldManager) {
            this.allCustomFieldObjectsMapById = null;
            this.fieldManager.getFieldLayoutManager().refresh();
        }
    }

    private List<GenericValue> getCustomFieldsFromDB() {
        ArrayList<GenericValue> customFields = new ArrayList<GenericValue>(this.delegator.findAll("CustomField"));
        Collections.sort(customFields, new CustomFieldComparator());
        return customFields;
    }

    @Override
    public void removeCustomFieldPossiblyLeavingOrphanedData(Long customFieldId) throws RemoveException {
        Assertions.notNull((String)"id", (Object)customFieldId);
        CustomField originalCustomField = this.getCustomFieldObject(customFieldId);
        if (originalCustomField != null) {
            this.removeCustomField(originalCustomField);
        } else {
            log.debug((Object)("Couldn't load customfield object for id '" + customFieldId + "'.  Trying to lookup field directly via the db." + "  Please note that deleting a custom field this way may leave some custom field data behind."));
            GenericValue customFieldGv = this.delegator.findByPrimaryKey("CustomField", EasyMap.build((Object)"id", (Object)customFieldId));
            if (customFieldGv != null) {
                log.debug((Object)("Customfield with id '" + customFieldId + "' retrieved successfully via the db."));
                String customFieldStringId = "customfield_" + customFieldId;
                this.removeCustomFieldAssociations(customFieldStringId);
                this.customFieldValuePersister.removeAllValues(customFieldStringId);
                try {
                    customFieldGv.remove();
                }
                catch (GenericEntityException e) {
                    throw new DataAccessException("Error deleting custom field gv with id '" + customFieldId + "'", e);
                }
                this.refresh();
                this.fieldManager.refresh();
            } else {
                throw new IllegalArgumentException("Tried to remove custom field with id '" + customFieldId + "' that doesn't exist!");
            }
        }
    }

    @Override
    public void removeCustomField(CustomField customField) throws RemoveException {
        this.removeCustomFieldAssociations(customField.getId());
        customField.remove();
        this.refresh();
        this.fieldManager.refresh();
    }

    private void removeCustomFieldAssociations(String customFieldId) throws RemoveException {
        this.fieldScreenManager.removeFieldScreenItems(customFieldId);
        this.delegator.removeByAnd("ColumnLayoutItem", EasyMap.build((Object)"fieldidentifier", (Object)customFieldId));
        this.delegator.removeByAnd("FieldLayoutItem", EasyMap.build((Object)"fieldidentifier", (Object)customFieldId));
        this.fieldConfigSchemeManager.removeInvalidFieldConfigSchemesForCustomField(customFieldId);
        this.notificationSchemeManager.removeSchemeEntitiesForField(customFieldId);
    }

    @Override
    public void removeCustomFieldValues(GenericValue issue) throws GenericEntityException {
        this.delegator.removeByAnd("CustomFieldValue", EasyMap.build((Object)"issue", (Object)issue.getLong("id")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void populateCache() {
        if (this.pluginAccessor.getPlugins().isEmpty()) {
            log.error((Object)"Attempting to Populate the Custom Fields cache in DefaultCustomFieldManager, however no plugins are loaded in the Plugin Manager.", (Throwable)new IllegalStateException("Plugin Manager not initialized."));
            return;
        }
        HashMap<Long, CustomFieldImpl> customFieldObjectsMapById = new HashMap<Long, CustomFieldImpl>();
        MultiHashMap customFieldObjectsMapByName = new MultiHashMap();
        ArrayList<CustomField> customFieldObjectsList = new ArrayList<CustomField>();
        try {
            List<GenericValue> customFields = this.getCustomFieldsFromDB();
            if (customFields != null && !customFields.isEmpty()) {
                for (GenericValue customFieldGv : customFields) {
                    CustomFieldImpl customFieldImpl = new CustomFieldImpl(customFieldGv, this, this.authenticationContext, this.constantsManager, this.fieldConfigSchemeManager, this.permissionManager, this.rendererManager, this.fieldConfigSchemeClauseContextUtil);
                    if (customFieldImpl.getCustomFieldType() == null) continue;
                    List<FieldConfigScheme> configForCustomField = this.fieldConfigSchemeManager.getConfigSchemesForField(customFieldImpl);
                    customFieldImpl.setConfigurationSchemes(configForCustomField);
                    customFieldObjectsList.add(customFieldImpl);
                    customFieldObjectsMapById.put(customFieldGv.getLong("id"), customFieldImpl);
                    customFieldObjectsMapByName.put((Object)customFieldGv.getString("name"), (Object)customFieldImpl);
                }
            }
            DefaultCustomFieldManager defaultCustomFieldManager = this;
            synchronized (defaultCustomFieldManager) {
                this.allCustomFieldObjectsMapById = new ConcurrentHashMap(customFieldObjectsMapById);
                this.allCustomFieldObjectsMapByName = customFieldObjectsMapByName;
                this.allCustomFieldObjectsList = customFieldObjectsList;
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception thrown in DefaultCustomFieldManager.populateCache()");
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public CustomField getCustomFieldInstance(GenericValue customFieldGv) {
        return new CustomFieldImpl(customFieldGv, this, this.authenticationContext, this.constantsManager, this.fieldConfigSchemeManager, this.permissionManager, this.rendererManager, this.fieldConfigSchemeClauseContextUtil);
    }

    @Override
    public void removeProjectAssociations(GenericValue project) {
        this.contextPersister.removeContextsForProject(project);
        this.refresh();
    }

    @Override
    public void removeProjectCategoryAssociations(ProjectCategory projectCategory) {
        this.contextPersister.removeContextsForProjectCategory(projectCategory);
        this.refresh();
    }

    @EventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.onPluginModuleEvent(event.getModule());
    }

    @EventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.onPluginModuleEvent(event.getModule());
    }

    private void onPluginModuleEvent(ModuleDescriptor<?> descriptor) {
        if (descriptor instanceof CustomFieldSearcherModuleDescriptor) {
            this.clear();
        }
    }
}

