/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.IssueConstantsComparator;
import com.atlassian.jira.issue.comparator.IssueKeyComparator;
import com.atlassian.jira.issue.comparator.IssueStatusComparator;
import com.atlassian.jira.issue.comparator.IssueTypeComparator;
import com.atlassian.jira.issue.comparator.PriorityComparator;
import com.atlassian.jira.issue.comparator.ResolutionComparator;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.LinkCollection;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.log4j.Logger;

public class LinkCollectionImpl
implements LinkCollection {
    private static final Logger log = Logger.getLogger(LinkCollectionImpl.class);
    private static final IssueKeyComparator KEY_COMPARATOR = new IssueKeyComparator();
    private static final IssueTypeComparator TYPE_COMPARATOR = new IssueTypeComparator();
    private static final IssueStatusComparator STATUS_COMPARATOR = new IssueStatusComparator();
    private static final PriorityComparator PRIORITY_COMPARATOR = new PriorityComparator();
    private static final ResolutionComparator RESOLUTION_COMPARATOR = new ResolutionComparator();
    private static final List<IssueConstantsComparator> DEFAULT_SORT_ORDER = ImmutableList.of((Object)TYPE_COMPARATOR, (Object)STATUS_COMPARATOR, (Object)PRIORITY_COMPARATOR);
    private static final String DEFAULT_SORT_ORDER_STRING = "type, status, priority";
    final Set<IssueLinkType> linkTypes;
    final Map<String, List<Issue>> outwardLinkMap;
    final Map<String, List<Issue>> inwardLinkMap;
    final User remoteUser;
    final boolean overrideSecurity;
    private final Comparator sortOrder;
    private String thisIssueId;

    public static Collection<String> getSortableFields() {
        return Arrays.asList("type", "status", "priority", "key", "resolution");
    }

    public LinkCollectionImpl(Long issueId, Set<IssueLinkType> linkTypes, Map<String, List<Issue>> outwardLinkMap, Map<String, List<Issue>> inwardLinkMap, User remoteUser, boolean overrideSecurity, ApplicationProperties applicationProperties) {
        this.linkTypes = linkTypes;
        this.outwardLinkMap = outwardLinkMap;
        this.inwardLinkMap = inwardLinkMap;
        this.remoteUser = remoteUser;
        this.overrideSecurity = overrideSecurity;
        this.thisIssueId = issueId == null ? "" : "[id=" + issueId + "]";
        String sortOrderStr = applicationProperties.getDefaultBackedString("jira.view.issue.links.sort.order");
        List<Object> sortOrder = new ArrayList();
        if (sortOrderStr != null) {
            StringTokenizer st = new StringTokenizer(sortOrderStr, ", ");
            while (st.hasMoreTokens()) {
                String field = st.nextToken();
                if ("type".equals(field)) {
                    sortOrder.add(TYPE_COMPARATOR);
                    continue;
                }
                if ("status".equals(field)) {
                    sortOrder.add(STATUS_COMPARATOR);
                    continue;
                }
                if ("priority".equals(field)) {
                    sortOrder.add(PRIORITY_COMPARATOR);
                    continue;
                }
                if ("key".equals(field)) {
                    sortOrder.add(KEY_COMPARATOR);
                    continue;
                }
                if (!"resolution".equals(field)) continue;
                sortOrder.add(RESOLUTION_COMPARATOR);
            }
        }
        if (sortOrder.isEmpty()) {
            log.warn((Object)"Cannot get property value for 'jira.view.issue.links.sort.order'. Defaulting to: type, status, priority");
            sortOrder = DEFAULT_SORT_ORDER;
        } else if (!sortOrder.contains(KEY_COMPARATOR)) {
            sortOrder.add(KEY_COMPARATOR);
        }
        this.sortOrder = ComparatorUtils.chainedComparator(sortOrder);
    }

    public LinkCollectionImpl(Long issueId, Set<IssueLinkType> linkTypes, Map<String, List<Issue>> outwardLinkMap, Map<String, List<Issue>> inwardLinkMap, User remoteUser, ApplicationProperties applicationProperties) {
        this(issueId, linkTypes, outwardLinkMap, inwardLinkMap, remoteUser, false, applicationProperties);
    }

    @Override
    public Set<IssueLinkType> getLinkTypes() {
        return this.linkTypes;
    }

    @Override
    public List<Issue> getOutwardIssues(String linkName) {
        if (this.outwardLinkMap == null) {
            return null;
        }
        List<Issue> outwardIssues = this.outwardLinkMap.get(linkName);
        if (outwardIssues == null) {
            return null;
        }
        return this.filterBrowseableIssues(outwardIssues);
    }

    @Override
    public List<Issue> getInwardIssues(String linkName) {
        if (this.inwardLinkMap == null) {
            return null;
        }
        List<Issue> inwardIssues = this.inwardLinkMap.get(linkName);
        if (inwardIssues == null) {
            return null;
        }
        return this.filterBrowseableIssues(inwardIssues);
    }

    private List<Issue> filterBrowseableIssues(Collection<Issue> issuesLinkedTo) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        for (Issue issue : issuesLinkedTo) {
            if (issue == null) {
                log.warn((Object)("Issue " + this.thisIssueId + " links to a non-existing issue!"));
                continue;
            }
            if (!this.overrideSecurity && !ManagerFactory.getPermissionManager().hasPermission(10, issue, this.remoteUser)) continue;
            result.add(issue);
        }
        Collections.sort(result, this.sortOrder);
        return result;
    }

    @Override
    public Collection<Issue> getAllIssues() {
        HashSet<Issue> allIssues = new HashSet<Issue>();
        this.getValuesFromMapList(this.outwardLinkMap, allIssues);
        this.getValuesFromMapList(this.inwardLinkMap, allIssues);
        return this.filterBrowseableIssues(allIssues);
    }

    private void getValuesFromMapList(Map<String, List<Issue>> values, Set<Issue> allIssues) {
        if (values != null) {
            for (List<Issue> list : values.values()) {
                allIssues.addAll(list);
            }
        }
    }

    @Override
    public boolean isDisplayLinkPanel() {
        if (this.linkTypes != null && !this.linkTypes.isEmpty()) {
            for (IssueLinkType issueLinkType : this.linkTypes) {
                List<Issue> outwardIssueLinks = this.getOutwardIssues(issueLinkType.getName());
                List<Issue> inwardIssues = this.getInwardIssues(issueLinkType.getName());
                if ((outwardIssueLinks == null || outwardIssueLinks.isEmpty()) && (inwardIssues == null || inwardIssues.isEmpty())) continue;
                return true;
            }
        }
        return false;
    }
}

