/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.ofbiz.AbstractOfBizValueWrapper;
import org.ofbiz.core.entity.GenericValue;

public class IssueLinkImpl
extends AbstractOfBizValueWrapper
implements IssueLink {
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueManager issueManager;
    private IssueLinkType issueLinkType;
    static final String LINK_TYPE_ID_FIELD_NAME = "linktype";
    static final String SOURCE_ID_FIELD_NAME = "source";
    static final String DESTINATION_ID_LINK_NAME = "destination";
    static final String SEQUENCE_FIELD_NAME = "sequence";

    public IssueLinkImpl(GenericValue genericValue, IssueLinkTypeManager issueLinkTypeManager, IssueManager issueManager) {
        super(genericValue);
        this.issueManager = issueManager;
        if (!"IssueLink".equals(genericValue.getEntityName())) {
            throw new IllegalArgumentException("Entity must be an 'IssueLink', not '" + genericValue.getEntityName() + "'.");
        }
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    @Override
    public Long getId() {
        return this.getGenericValue().getLong("id");
    }

    @Override
    public Long getLinkTypeId() {
        return this.getGenericValue().getLong(LINK_TYPE_ID_FIELD_NAME);
    }

    @Override
    public Long getSourceId() {
        return this.getGenericValue().getLong(SOURCE_ID_FIELD_NAME);
    }

    @Override
    public Long getDestinationId() {
        return this.getGenericValue().getLong(DESTINATION_ID_LINK_NAME);
    }

    @Override
    public Long getSequence() {
        return this.getGenericValue().getLong(SEQUENCE_FIELD_NAME);
    }

    @Override
    public IssueLinkType getIssueLinkType() {
        if (this.issueLinkType == null) {
            this.issueLinkType = this.issueLinkTypeManager.getIssueLinkType(this.getLinkTypeId());
        }
        return this.issueLinkType;
    }

    @Override
    public Issue getSourceObject() {
        return this.getIssueObject(this.getSourceId());
    }

    @Override
    public Issue getDestinationObject() {
        return this.getIssueObject(this.getDestinationId());
    }

    @Override
    public boolean isSystemLink() {
        return this.getIssueLinkType().isSystemLinkType();
    }

    private Issue getIssueObject(Long issueId) {
        return this.issueManager.getIssueObject(issueId);
    }
}

