/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.link.RemoteIssueLinkCreateEvent;
import com.atlassian.jira.event.issue.link.RemoteIssueLinkDeleteEvent;
import com.atlassian.jira.event.issue.link.RemoteIssueLinkUpdateEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.UpdateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.issue.link.RemoteIssueLinkStore;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class DefaultRemoteIssueLinkManager
implements RemoteIssueLinkManager {
    public static final int MAX_LONG_VARCHAR_LENGTH = 255;
    private final RemoteIssueLinkStore remoteIssueLinkStore;
    private final IssueManager issueManager;
    private final IssueUpdater issueUpdater;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final EventPublisher eventPublisher;
    private static final Result TRUE = new Result(true, null);

    public DefaultRemoteIssueLinkManager(RemoteIssueLinkStore remoteIssueLinkStore, IssueManager issueManager, IssueUpdater issueUpdater, I18nHelper.BeanFactory i18nBeanFactory, EventPublisher eventPublisher) {
        this.remoteIssueLinkStore = remoteIssueLinkStore;
        this.issueManager = issueManager;
        this.issueUpdater = issueUpdater;
        this.i18nBeanFactory = i18nBeanFactory;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public RemoteIssueLink getRemoteIssueLink(Long remoteIssueLinkId) {
        return this.remoteIssueLinkStore.getRemoteIssueLink(remoteIssueLinkId);
    }

    @Override
    public List<RemoteIssueLink> getRemoteIssueLinksForIssue(Issue issue) {
        return this.remoteIssueLinkStore.getRemoteIssueLinksForIssue(issue);
    }

    @Override
    public RemoteIssueLink getRemoteIssueLinkByGlobalId(Issue issue, String globalId) {
        return (RemoteIssueLink)Iterables.get(this.remoteIssueLinkStore.getRemoteIssueLinksByGlobalId(issue, globalId), (int)0, null);
    }

    @Override
    public RemoteIssueLink createRemoteIssueLink(RemoteIssueLink remoteIssueLink, User user) throws CreateException {
        this.validateMandatoryFieldsForCreate(remoteIssueLink);
        this.validateFieldLengthsForCreate(remoteIssueLink);
        this.validateUrlsForCreate(remoteIssueLink);
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        if (issue == null) {
            throw new CreateException("Issue with id '" + remoteIssueLink.getIssueId() + "' does not exist.");
        }
        this.validateGlobalIdForCreate(issue, remoteIssueLink.getGlobalId());
        RemoteIssueLink created = this.remoteIssueLinkStore.createRemoteIssueLink(remoteIssueLink);
        if (this.hasDuplicateGlobalId(issue, created)) {
            this.remoteIssueLinkStore.removeRemoteIssueLink(created.getId());
            throw new CreateException("A remote issue link already exists on this issue with the globalId '" + created.getGlobalId() + "'");
        }
        this.createChangeItemForCreate(created, issue, user);
        this.eventPublisher.publish((Object)new RemoteIssueLinkCreateEvent(created.getId(), created.getApplicationType()));
        return created;
    }

    @Override
    public void updateRemoteIssueLink(RemoteIssueLink remoteIssueLink, User user) throws UpdateException {
        this.validateMandatoryFieldsForUpdate(remoteIssueLink);
        this.validateFieldLengthsForUpdate(remoteIssueLink);
        this.validateUrlsForUpdate(remoteIssueLink);
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        if (issue == null) {
            throw new UpdateException("Issue with id '" + remoteIssueLink.getIssueId() + "' does not exist.");
        }
        RemoteIssueLink found = this.getRemoteIssueLink(remoteIssueLink.getId());
        if (found == null) {
            throw new UpdateException("Remote link with id '" + remoteIssueLink.getId() + "' does not exist.");
        }
        this.validateGlobalIdForUpdate(issue, found.getGlobalId(), remoteIssueLink.getGlobalId());
        this.remoteIssueLinkStore.updateRemoteIssueLink(remoteIssueLink);
        if (found.getGlobalId() != null && !found.getGlobalId().equals(remoteIssueLink.getGlobalId()) && this.hasDuplicateGlobalId(issue, remoteIssueLink)) {
            this.remoteIssueLinkStore.updateRemoteIssueLink(found);
            throw new UpdateException("A remote issue link already exists on this issue with the globalId '" + remoteIssueLink.getGlobalId() + "'");
        }
        this.createChangeItemForUpdate(found, remoteIssueLink, issue, user);
        this.eventPublisher.publish((Object)new RemoteIssueLinkUpdateEvent(remoteIssueLink.getId(), remoteIssueLink.getApplicationType()));
    }

    @Override
    public void removeRemoteIssueLink(Long remoteIssueLinkId, User user) {
        RemoteIssueLink remoteIssueLink = this.getRemoteIssueLink(remoteIssueLinkId);
        if (remoteIssueLink == null) {
            return;
        }
        this.removeRemoteIssueLink(remoteIssueLink, user);
    }

    @Override
    public void removeRemoteIssueLinkByGlobalId(Issue issue, String globalId, User user) {
        List<RemoteIssueLink> remoteIssueLinks = this.remoteIssueLinkStore.getRemoteIssueLinksByGlobalId(issue, globalId);
        if (remoteIssueLinks.isEmpty()) {
            return;
        }
        for (RemoteIssueLink remoteIssueLink : Iterables.reverse(remoteIssueLinks)) {
            this.removeRemoteIssueLink(remoteIssueLink, user);
        }
    }

    private void removeRemoteIssueLink(RemoteIssueLink remoteIssueLink, User user) {
        this.remoteIssueLinkStore.removeRemoteIssueLink(remoteIssueLink.getId());
        MutableIssue issue = this.issueManager.getIssueObject(remoteIssueLink.getIssueId());
        this.createChangeItemForRemove(remoteIssueLink, issue, user);
        this.eventPublisher.publish((Object)new RemoteIssueLinkDeleteEvent(remoteIssueLink.getId()));
    }

    private void validateGlobalIdForCreate(Issue issue, String globalId) throws CreateException {
        Result result = this.validateGlobalId(issue, globalId);
        if (!result.isValid()) {
            throw new CreateException(result.getMessage());
        }
    }

    private void validateGlobalIdForUpdate(Issue issue, String oldGlobalId, String newGlobalId) throws UpdateException {
        Result result;
        if (!this.isEqual(oldGlobalId, newGlobalId) && !(result = this.validateGlobalId(issue, newGlobalId)).isValid()) {
            throw new UpdateException(result.getMessage());
        }
    }

    private Result validateGlobalId(Issue issue, String globalId) {
        if (globalId == null) {
            return TRUE;
        }
        if (this.getRemoteIssueLinkByGlobalId(issue, globalId) != null) {
            return new Result(false, "A remote issue link already exists on this issue with the globalId '" + globalId + "'");
        }
        return TRUE;
    }

    private boolean hasDuplicateGlobalId(Issue issue, RemoteIssueLink link) {
        if (link.getGlobalId() == null) {
            return false;
        }
        List<RemoteIssueLink> links = this.remoteIssueLinkStore.getRemoteIssueLinksByGlobalId(issue, link.getGlobalId());
        return links.size() > 1;
    }

    private void validateMandatoryFieldsForCreate(RemoteIssueLink remoteIssueLink) throws CreateException {
        Result result = this.validateMandatoryFields(remoteIssueLink);
        if (!result.isValid()) {
            throw new CreateException(result.getMessage());
        }
    }

    private void validateMandatoryFieldsForUpdate(RemoteIssueLink remoteIssueLink) throws UpdateException {
        if (remoteIssueLink.getId() == null) {
            throw new UpdateException(this.missingMandatoryFieldMessage("id"));
        }
        Result result = this.validateMandatoryFields(remoteIssueLink);
        if (!result.isValid()) {
            throw new UpdateException(result.getMessage());
        }
    }

    private Result validateMandatoryFields(RemoteIssueLink remoteIssueLink) {
        if (remoteIssueLink.getIssueId() == null) {
            return new Result(false, this.missingMandatoryFieldMessage("issueId"));
        }
        if (StringUtils.isBlank((String)remoteIssueLink.getTitle())) {
            return new Result(false, this.missingMandatoryFieldMessage("title"));
        }
        if (StringUtils.isBlank((String)remoteIssueLink.getUrl())) {
            return new Result(false, this.missingMandatoryFieldMessage("url"));
        }
        return TRUE;
    }

    private void validateFieldLengthsForCreate(RemoteIssueLink remoteIssueLink) throws CreateException {
        Result result = this.validateFieldLengths(remoteIssueLink);
        if (!result.isValid()) {
            throw new CreateException(result.getMessage());
        }
    }

    private void validateFieldLengthsForUpdate(RemoteIssueLink remoteIssueLink) throws UpdateException {
        Result result = this.validateFieldLengths(remoteIssueLink);
        if (!result.isValid()) {
            throw new UpdateException(result.getMessage());
        }
    }

    private Result validateFieldLengths(RemoteIssueLink remoteIssueLink) {
        if (this.isLongerThan(remoteIssueLink.getGlobalId(), 255)) {
            return new Result(false, this.tooLongFieldMessage("globalId", 255));
        }
        if (this.isLongerThan(remoteIssueLink.getTitle(), 255)) {
            return new Result(false, this.tooLongFieldMessage("title", 255));
        }
        if (this.isLongerThan(remoteIssueLink.getRelationship(), 255)) {
            return new Result(false, this.tooLongFieldMessage("relationship", 255));
        }
        if (this.isLongerThan(remoteIssueLink.getApplicationType(), 255)) {
            return new Result(false, this.tooLongFieldMessage("applicationType", 255));
        }
        if (this.isLongerThan(remoteIssueLink.getApplicationName(), 255)) {
            return new Result(false, this.tooLongFieldMessage("applicationName", 255));
        }
        return TRUE;
    }

    private boolean isLongerThan(String value, int length) {
        return value != null && value.length() > length;
    }

    private void validateUrlsForCreate(RemoteIssueLink remoteIssueLink) throws CreateException {
        Result result = this.validateUrls(remoteIssueLink);
        if (!result.isValid()) {
            throw new CreateException(result.getMessage());
        }
    }

    private void validateUrlsForUpdate(RemoteIssueLink remoteIssueLink) throws UpdateException {
        Result result = this.validateUrls(remoteIssueLink);
        if (!result.isValid()) {
            throw new UpdateException(result.getMessage());
        }
    }

    private Result validateUrls(RemoteIssueLink remoteIssueLink) {
        if (!this.isValidUrl(remoteIssueLink.getUrl())) {
            return new Result(false, this.invalidUrlMessage("url"));
        }
        if (!this.isValidUrl(remoteIssueLink.getIconUrl())) {
            return new Result(false, this.invalidUrlMessage("iconUrl"));
        }
        if (!this.isValidUrl(remoteIssueLink.getStatusIconUrl())) {
            return new Result(false, this.invalidUrlMessage("statusIconUrl"));
        }
        if (!this.isValidUrl(remoteIssueLink.getStatusIconLink())) {
            return new Result(false, this.invalidUrlMessage("statusIconLink"));
        }
        return TRUE;
    }

    private boolean isValidUrl(String url) {
        if (url == null) {
            return true;
        }
        try {
            new URI(url);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private void createChangeItemForCreate(RemoteIssueLink remoteIssueLink, Issue issue, User remoteUser) {
        ChangeItemBean changeItemBean = new ChangeItemBean("jira", "RemoteIssueLink", null, null, remoteIssueLink.getId().toString(), this.getChangeItemDescription(remoteIssueLink, remoteUser));
        this.createChangeItem(changeItemBean, issue, remoteUser);
    }

    private void createChangeItemForRemove(RemoteIssueLink remoteIssueLink, Issue issue, User remoteUser) {
        ChangeItemBean changeItemBean = new ChangeItemBean("jira", "RemoteIssueLink", remoteIssueLink.getId().toString(), this.getChangeItemDescription(remoteIssueLink, remoteUser), null, null);
        this.createChangeItem(changeItemBean, issue, remoteUser);
    }

    private void createChangeItemForUpdate(RemoteIssueLink oldLink, RemoteIssueLink newLink, Issue issue, User remoteUser) {
        ChangeItemBean changeItemBean = new ChangeItemBean("jira", "RemoteIssueLink", oldLink.getId().toString(), this.getChangeItemDescription(oldLink, remoteUser), newLink.getId().toString(), this.getChangeItemDescription(newLink, remoteUser));
        this.createChangeItem(changeItemBean, issue, remoteUser);
    }

    private String getChangeItemDescription(RemoteIssueLink remoteIssueLink, User remoteUser) {
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(remoteUser);
        String applicationName = StringUtils.defaultIfEmpty((String)remoteIssueLink.getApplicationName(), (String)i18nHelper.getText("remotelink.manager.changeitem.applicationname.default"));
        return i18nHelper.getText("remotelink.manager.changeitem", remoteIssueLink.getTitle(), applicationName);
    }

    private void createChangeItem(ChangeItemBean changeItemBean, Issue issue, User remoteUser) {
        GenericValue issueGv = issue.getGenericValue();
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issueGv, issueGv, EventType.ISSUE_UPDATED_ID, remoteUser);
        issueUpdateBean.setDispatchEvent(false);
        issueUpdateBean.setChangeItems(EasyList.build((Object)changeItemBean));
        this.issueUpdater.doUpdate(issueUpdateBean, true);
    }

    private boolean isEqual(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    private String missingMandatoryFieldMessage(String fieldName) {
        return "Missing mandatory field: " + fieldName;
    }

    private String invalidUrlMessage(String fieldName) {
        return "Invalid " + fieldName + ", it must be a valid URI";
    }

    private String tooLongFieldMessage(String fieldName, int maxLength) {
        return "The length of the " + fieldName + " cannot exceed " + maxLength + " characters.";
    }

    private static class Result {
        private final boolean valid;
        private final String message;

        private Result(boolean valid, String message) {
            this.valid = valid;
            this.message = message;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

