/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.ofbiz.core.entity.GenericValue;

public class DefaultLabelUtil
implements LabelUtil {
    private final SearchService searchService;
    private final CustomFieldManager customFieldManager;

    public DefaultLabelUtil(SearchService searchService, CustomFieldManager customFieldManager) {
        this.searchService = searchService;
        this.customFieldManager = customFieldManager;
    }

    @Override
    public String getLabelJql(User user, String label) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder jqlClauseBuilder = jqlQueryBuilder.where();
        jqlClauseBuilder.labels(label);
        return this.searchService.getQueryString(user, jqlQueryBuilder.buildQuery());
    }

    @Override
    public String getLabelJql(User user, Long customFieldId, String label) {
        Assertions.notNull("customFieldId", customFieldId);
        CustomField labelField = this.customFieldManager.getCustomFieldObject(customFieldId);
        HashSet<Long> projectIds = new HashSet<Long>();
        List<GenericValue> associatedProjects = labelField.getAssociatedProjects();
        if (null != associatedProjects) {
            for (GenericValue projectGv : associatedProjects) {
                if (null == projectGv) continue;
                projectIds.add(projectGv.getLong("id"));
            }
        }
        return this.getLabelJql(user, labelField, projectIds, this.getAssociatedIssueTypeIds(labelField), label);
    }

    @Override
    public String getLabelJqlForProject(User user, Long projectId, String label) {
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder jqlClauseBuilder = jqlQueryBuilder.where();
        jqlClauseBuilder.project(projectId).and();
        if (label == null) {
            jqlClauseBuilder.labelsIsEmpty();
        } else {
            jqlClauseBuilder.labels(label);
        }
        return this.searchService.getQueryString(user, jqlQueryBuilder.buildQuery());
    }

    @Override
    public String getLabelJqlForProject(User user, Long projectId, Long customFieldId, String label) {
        Assertions.notNull("customFieldId", customFieldId);
        CustomField labelField = this.customFieldManager.getCustomFieldObject(customFieldId);
        return this.getLabelJql(user, labelField, CollectionBuilder.newBuilder(projectId).asSet(), this.getAssociatedIssueTypeIds(labelField), label);
    }

    private String getLabelJql(User user, CustomField labelField, Set<Long> associatedProjectIds, Set<String> associatedIssueTypeIds, String label) {
        boolean hasAssociatedIssueTypeIds;
        JqlQueryBuilder jqlQueryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder jqlClauseBuilder = jqlQueryBuilder.where();
        boolean hasAssociatedProjectIds = null != associatedProjectIds && !associatedProjectIds.isEmpty();
        boolean bl = hasAssociatedIssueTypeIds = null != associatedIssueTypeIds && !associatedIssueTypeIds.isEmpty();
        if (hasAssociatedProjectIds || hasAssociatedIssueTypeIds) {
            jqlClauseBuilder = jqlClauseBuilder.sub().defaultAnd();
            if (hasAssociatedProjectIds) {
                jqlClauseBuilder = jqlClauseBuilder.project(associatedProjectIds.toArray(new Long[associatedProjectIds.size()]));
            }
            if (hasAssociatedIssueTypeIds) {
                jqlClauseBuilder = jqlClauseBuilder.issueType(associatedIssueTypeIds.toArray(new String[associatedIssueTypeIds.size()]));
            }
            jqlClauseBuilder.endsub().and().customField(labelField.getIdAsLong()).eq().string(label);
        } else {
            jqlClauseBuilder.customField(labelField.getIdAsLong()).eq().string(label);
        }
        return this.searchService.getQueryString(user, jqlQueryBuilder.buildQuery());
    }

    private Set<String> getAssociatedIssueTypeIds(CustomField labelField) {
        TreeSet<String> issueTypeIds = new TreeSet<String>();
        List<GenericValue> associatedIssueTypes = labelField.getAssociatedIssueTypes();
        if (null != associatedIssueTypes) {
            for (GenericValue issueTypeGv : associatedIssueTypes) {
                if (null == issueTypeGv) continue;
                issueTypeIds.add(issueTypeGv.getString("id"));
            }
        }
        return issueTypeIds;
    }
}

