/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.MultiMap;
import com.atlassian.jira.util.collect.MultiMaps;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class AlphabeticalLabelGroupingSupport {
    private final Set<String> data;
    private MultiMap<String, String, Set<String>> alphabetBuckets = MultiMaps.create(new Supplier<Set<String>>(){

        @Override
        public Set<String> get() {
            return new TreeSet<String>();
        }
    });
    public static final String NUMERIC = "0-9";
    private static final String[] KEYS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String LAST_KEY = KEYS[KEYS.length - 1];
    private static final int MIN_GROUP_SIZE = 10;
    private Collator collator = Collator.getInstance();

    public AlphabeticalLabelGroupingSupport(Set<String> labels) {
        this.data = labels;
        this.fillBuckets();
        this.mergeBuckets();
    }

    public Set<String> getContents(String key) {
        return (Set)this.alphabetBuckets.get(key);
    }

    public Collection<String> getKeys() {
        TreeSet<String> keys = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.equals(o2)) {
                    return 0;
                }
                if (AlphabeticalLabelGroupingSupport.NUMERIC.equals(o1)) {
                    return 1;
                }
                if (AlphabeticalLabelGroupingSupport.NUMERIC.equals(o2)) {
                    return -1;
                }
                return AlphabeticalLabelGroupingSupport.this.collator.compare(o1, o2);
            }
        });
        keys.addAll(this.alphabetBuckets.keySet());
        return keys;
    }

    private void fillBuckets() {
        for (String label : this.data) {
            char firstCharacter = this.extractFirstCharacter(label);
            if (Character.isLetter(firstCharacter)) {
                this.alphabetBuckets.put(Character.toUpperCase(firstCharacter) + "", label);
                continue;
            }
            if (!Character.isDigit(firstCharacter)) continue;
            this.alphabetBuckets.put(NUMERIC, label);
        }
    }

    private void mergeBuckets() {
        int minGroupSize = this.alphabetBuckets.size() / KEYS.length + 10;
        String lastBucketKey = KEYS[0];
        boolean flipLastBucketKey = true;
        TreeSet currentBucket = new TreeSet();
        for (String currentKey : KEYS) {
            Set currentLabels;
            if (flipLastBucketKey) {
                lastBucketKey = currentKey;
                flipLastBucketKey = false;
            }
            if ((currentLabels = (Set)this.alphabetBuckets.remove(currentKey + "")) == null) continue;
            currentBucket.addAll(currentLabels);
            if (currentBucket.size() < minGroupSize) continue;
            this.alphabetBuckets.put(this.getBucketKey(lastBucketKey, currentKey), (String)((Object)currentBucket));
            currentBucket = new TreeSet();
            flipLastBucketKey = true;
        }
        if (!currentBucket.isEmpty()) {
            this.alphabetBuckets.put(this.getBucketKey(lastBucketKey, LAST_KEY), (String)((Object)currentBucket));
        }
    }

    private String getBucketKey(String lastBucketKey, String currentKey) {
        if (lastBucketKey.equals(currentKey)) {
            return lastBucketKey;
        }
        return lastBucketKey + "-" + currentKey;
    }

    private char extractFirstCharacter(String label) {
        char firstCharacter = '\u0000';
        if (StringUtils.isNotBlank((String)label)) {
            firstCharacter = label.charAt(0);
        }
        return firstCharacter;
    }
}

