/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.worklog.WorkRatio;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class WorkRatioIndexer
extends BaseFieldIndexer {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final ApplicationProperties applicationProperties;

    public WorkRatioIndexer(FieldVisibilityManager fieldVisibilityManager, ApplicationProperties applicationProperties) {
        super(fieldVisibilityManager);
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getId() {
        return SystemSearchConstants.forWorkRatio().getFieldId();
    }

    @Override
    public String getDocumentFieldId() {
        return SystemSearchConstants.forWorkRatio().getIndexField();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.applicationProperties.getOption("jira.option.timetracking") && this.fieldVisibilityManager.isFieldVisible("timetracking", issue);
    }

    @Override
    public void addIndex(Document doc, Issue issue) {
        if (issue.getOriginalEstimate() != null) {
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), WorkRatio.getPaddedWorkRatio(issue.getGenericValue()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }
}

