/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class WatchesIndexer
extends BaseFieldIndexer {
    private final WatcherManager watcherManager;

    public WatchesIndexer(FieldVisibilityManager fieldVisibilityManager, WatcherManager watcherManager) {
        super(fieldVisibilityManager);
        this.watcherManager = watcherManager;
    }

    @Override
    public String getId() {
        return SystemSearchConstants.forWatches().getFieldId();
    }

    @Override
    public String getDocumentFieldId() {
        return SystemSearchConstants.forWatches().getIndexField();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.watcherManager.isWatchingEnabled();
    }

    @Override
    public void addIndex(Document doc, Issue issue) {
        this.indexLongAsPaddedKeywordWithDefault(doc, this.getDocumentFieldId(), issue.getWatches(), 0L, issue);
    }
}

