/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.UserFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.watchers.IssueWatcherAccessor;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class WatcherIndexer
extends UserFieldIndexer {
    private final IssueWatcherAccessor watcherAccessor;

    public WatcherIndexer(FieldVisibilityManager fieldVisibilityManager, IssueWatcherAccessor watcherAccessor) {
        super(fieldVisibilityManager);
        this.watcherAccessor = watcherAccessor;
    }

    @Override
    public String getId() {
        return SystemSearchConstants.forWatchers().getFieldId();
    }

    @Override
    public String getDocumentFieldId() {
        return SystemSearchConstants.forWatchers().getIndexField();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.watcherAccessor.isWatchingEnabled();
    }

    @Override
    public void addIndex(Document doc, Issue issue) {
        for (String username : this.watcherAccessor.getWatcherNames(issue)) {
            this.indexUsername(doc, this.getDocumentFieldId(), username, issue);
        }
    }
}

