/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.UserFieldIndexer;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.vote.IssueVoterAccessor;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class VoterIndexer
extends UserFieldIndexer {
    private final IssueVoterAccessor voterAccessor;

    public VoterIndexer(FieldVisibilityManager fieldVisibilityManager, IssueVoterAccessor voterAccessor) {
        super(fieldVisibilityManager);
        this.voterAccessor = voterAccessor;
    }

    @Override
    public String getId() {
        return SystemSearchConstants.forVoters().getFieldId();
    }

    @Override
    public String getDocumentFieldId() {
        return SystemSearchConstants.forVoters().getIndexField();
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.voterAccessor.isVotingEnabled();
    }

    @Override
    public void addIndex(Document doc, Issue issue) {
        for (String username : this.voterAccessor.getVoterNames(issue)) {
            this.indexUsername(doc, this.getDocumentFieldId(), username, issue);
        }
    }
}

