/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class SubTaskIndexer
extends BaseFieldIndexer {
    private final SubTaskManager subTaskManager;
    private final IssueLinkManager issueLinkManager;

    public SubTaskIndexer(FieldVisibilityManager fieldVisibilityManager, SubTaskManager subTaskManager, IssueLinkManager issueLinkManager) {
        super(fieldVisibilityManager);
        this.subTaskManager = subTaskManager;
        this.issueLinkManager = issueLinkManager;
    }

    @Override
    public String getId() {
        return "subtasks";
    }

    @Override
    public String getDocumentFieldId() {
        return "issue_subtasks";
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.subTaskManager.isSubTasksEnabled();
    }

    @Override
    public void addIndex(Document doc, Issue issue) {
        List<IssueLink> outwardLinks = this.issueLinkManager.getOutwardLinks(issue.getId());
        for (IssueLink outwardLink : outwardLinks) {
            if (!outwardLink.getIssueLinkType().isSubTaskLinkType()) continue;
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), outwardLink.getDestinationId().toString(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
    }
}

